/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.util.ValueSetter;

public final class GroupValueSetter
implements ValueSetter {
    private final ParameterGroupDescriptor groupDescriptor;
    private final Field container;
    private final Supplier<ReflectionCache> reflectionCache;
    private final Supplier<ExpressionManager> expressionManager;

    public static List<ValueSetter> settersFor(ParameterizedModel model, Supplier<ReflectionCache> reflectionCache, Supplier<ExpressionManager> expressionManager) {
        ArrayList<ValueSetter> setters = new ArrayList<ValueSetter>();
        model.getParameterGroupModels().stream().filter(group -> !group.isShowInDsl()).filter(group -> !group.getName().equals("General")).forEach(group -> group.getModelProperty(ParameterGroupModelProperty.class).ifPresent(arg_0 -> GroupValueSetter.lambda$settersFor$2(setters, (Supplier)reflectionCache, (Supplier)expressionManager, arg_0)));
        return setters;
    }

    public GroupValueSetter(ParameterGroupDescriptor groupDescriptor, Supplier<ReflectionCache> reflectionCache, Supplier<ExpressionManager> expressionManager) {
        this.groupDescriptor = groupDescriptor;
        Preconditions.checkArgument(groupDescriptor.getContainer() instanceof Field, "Only field contained parameter groups are allowed");
        this.container = (Field)groupDescriptor.getContainer();
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
    }

    @Override
    public void set(Object target, ResolverSetResult result) throws MuleException {
        this.container.setAccessible(true);
        ParameterGroupObjectBuilder parameterGroupObjectBuilder = new ParameterGroupObjectBuilder(this.groupDescriptor, this.reflectionCache.get(), this.expressionManager.get());
        Object value = parameterGroupObjectBuilder.build(result);
        try {
            this.container.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static /* synthetic */ void lambda$settersFor$2(List setters, Supplier reflectionCache, Supplier expressionManager, ParameterGroupModelProperty property) {
        if (property.getDescriptor().getContainer() instanceof Field) {
            setters.add(new GroupValueSetter(property.getDescriptor(), reflectionCache, expressionManager));
        }
    }
}

