/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.extension.api.runtime.source.SdkSourceFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.ResolverBasedSourceFactoryContext;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionProvider;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceWrapper;
import org.mule.runtime.module.extension.internal.runtime.source.poll.PollingSourceWrapper;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.Source;

public class SourceAdapterFactory {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final ResolverSet sourceParameters;
    private final ResolverSet successCallbackParameters;
    private final ResolverSet errorCallbackParameters;
    private final CursorProviderFactory<?> cursorProviderFactory;
    private final Optional<BackPressureAction> backPressureAction;
    private final ExpressionManager expressionManager;
    private final String defaultEncoding;
    private final SystemExceptionHandler exceptionHandler;

    public SourceAdapterFactory(ExtensionModel extensionModel, SourceModel sourceModel, ResolverSet sourceParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters, CursorProviderFactory<?> cursorProviderFactory, MessageSource.BackPressureStrategy backPressureStrategy, ExpressionManager expressionManager, String defaultEncoding, SystemExceptionHandler exceptionHandler) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.sourceParameters = sourceParameters;
        this.successCallbackParameters = successCallbackParameters;
        this.errorCallbackParameters = errorCallbackParameters;
        this.cursorProviderFactory = cursorProviderFactory;
        this.backPressureAction = MuleExtensionUtils.toBackPressureAction(backPressureStrategy);
        this.expressionManager = expressionManager;
        this.defaultEncoding = defaultEncoding;
        this.exceptionHandler = exceptionHandler;
    }

    public SourceAdapter createAdapter(Optional<ConfigurationInstance> configurationInstance, SourceCallbackFactory sourceCallbackFactory, Component component, SourceConnectionManager connectionManager, boolean restarting) {
        try {
            SdkSourceFactory sourceFactory = MuleExtensionUtils.getSdkSourceFactory(this.sourceModel);
            ComponentLocation componentLocation = component.getLocation();
            Optional<ConnectionProvider<?>> connectionProvider = this.getConnectionProvider(configurationInstance, connectionManager, componentLocation);
            ResolverBasedSourceFactoryContext context = new ResolverBasedSourceFactoryContext(this.sourceModel, componentLocation, this.sourceParameters, configurationInstance, connectionProvider, this.expressionManager, this.defaultEncoding);
            org.mule.runtime.extension.api.runtime.source.Source<?, ?> source = sourceFactory.createMessageSource(context);
            Source<?, ?> sdkSource = source instanceof SdkSourceWrapper ? ((SdkSourceWrapper)((Object)source)).getDelegate() : SdkSourceAdapterFactory.createAdapter(source);
            if (sdkSource instanceof PollingSource) {
                sdkSource = this.wrapPollingSource((PollingSource)sdkSource, configurationInstance, componentLocation);
            }
            return new SourceAdapter(this.extensionModel, this.sourceModel, sdkSource, configurationInstance, this.cursorProviderFactory, sourceCallbackFactory, component, this.sourceParameters, this.successCallbackParameters, this.errorCallbackParameters, this.backPressureAction);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not create generator for source '%s'", this.sourceModel.getName())), (Throwable)e);
        }
    }

    private Source<?, ?> wrapPollingSource(PollingSource<?, ?> pollingSource, Optional<ConfigurationInstance> configurationInstance, ComponentLocation componentLocation) throws MuleException {
        try (ValueResolvingContext context = ValueResolvingContext.builder(null, this.expressionManager).withConfig(configurationInstance).build();){
            SchedulingStrategy scheduler = this.resolveSchedulingStrategy(context);
            int maxItemsPerPoll = this.resolveMaxItemsPerPoll(context);
            PollingSourceWrapper pollingSourceWrapper = new PollingSourceWrapper(pollingSource, scheduler, maxItemsPerPoll, this.exceptionHandler, componentLocation);
            return pollingSourceWrapper;
        }
    }

    private SchedulingStrategy resolveSchedulingStrategy(ValueResolvingContext context) throws MuleException {
        ValueResolver<?> schedulingValueResolver = this.sourceParameters.getResolvers().get("schedulingStrategy");
        if (schedulingValueResolver == null) {
            return new FixedFrequencyScheduler(60000L, 0L, TimeUnit.MILLISECONDS);
        }
        return (SchedulingStrategy)schedulingValueResolver.resolve(context);
    }

    private int resolveMaxItemsPerPoll(ValueResolvingContext context) throws MuleException {
        ValueResolver<?> valueResolver = this.sourceParameters.getResolvers().get("maxItemsPerPoll");
        if (valueResolver == null) {
            return Integer.MAX_VALUE;
        }
        int maxItemsPerPoll = (Integer)valueResolver.resolve(context);
        if (maxItemsPerPoll < 1) {
            throw new IllegalArgumentException(String.format("The %s parameter must have a value greater than 1", "maxItemsPerPoll"));
        }
        return maxItemsPerPoll;
    }

    private Optional<ConnectionProvider<?>> getConnectionProvider(Optional<ConfigurationInstance> configurationInstance, SourceConnectionManager connectionManager, ComponentLocation componentLocation) throws MuleException {
        if (!this.sourceModel.requiresConnection()) {
            return Optional.empty();
        }
        ConfigurationInstance config = configurationInstance.orElseThrow(() -> new DefaultMuleException(I18nMessageFactory.createStaticMessage("Message Source on root component '%s' requires a connection but it doesn't point to any configuration. Please review your application", componentLocation.getRootContainerName())));
        if (!config.getConnectionProvider().isPresent()) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage(String.format("Message Source on root component '%s' requires a connection, but points to config '%s' which doesn't specify any. Please review your application", componentLocation.getRootContainerName(), config.getName())));
        }
        return Optional.of(new SourceConnectionProvider(connectionManager, config));
    }

    public ResolverSet getSourceParameters() {
        return this.sourceParameters;
    }
}

