/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Sink;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

class PerThreadSink
implements Sink,
Disposable {
    private final Supplier<Sink> sinkSupplier;
    private final Cache<Thread, Sink> sinkCache = Caffeine.newBuilder().weakValues().removalListener((k, v, c) -> LifecycleUtils.disposeIfNeeded(v, (Logger)NOPLogger.NOP_LOGGER)).build();

    public PerThreadSink(Supplier<Sink> sinkSupplier) {
        this.sinkSupplier = sinkSupplier;
    }

    @Override
    public void accept(CoreEvent event) {
        try {
            ((Sink)this.sinkCache.get((Object)Thread.currentThread(), t -> this.sinkSupplier.get())).accept(event);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create Sink for Thread " + String.valueOf(Thread.currentThread()), e);
        }
    }

    @Override
    public BackPressureReason emit(CoreEvent event) {
        try {
            return ((Sink)this.sinkCache.get((Object)Thread.currentThread(), t -> this.sinkSupplier.get())).emit(event);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create Sink for Thread " + String.valueOf(Thread.currentThread()), e);
        }
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.sinkCache.asMap().entrySet(), (Logger)NOPLogger.NOP_LOGGER);
        this.sinkCache.invalidateAll();
    }
}

