/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction.xa;

import org.mule.runtime.api.tx.xa.ResourceManagerException;
import org.mule.runtime.core.internal.util.UUID;

public abstract class AbstractTransactionContext {
    protected String id = UUID.getUUID();
    protected long timeout;
    protected int status = 6;
    private boolean readOnly = true;
    protected boolean finished = false;

    protected AbstractTransactionContext() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append("[");
        sb.append(this.getStatusString());
        if (this.readOnly) {
            sb.append(", readonly");
        }
        if (this.finished) {
            sb.append(", finished");
        }
        sb.append("]");
        return sb.toString();
    }

    private String getStatusString() {
        return switch (this.status) {
            case 0 -> "active";
            case 1 -> "marked rollback";
            case 2 -> "prepared";
            case 3 -> "committed";
            case 4 -> "rolled back";
            case 5 -> "unknown";
            case 6 -> "no transaction";
            case 7 -> "preparing";
            case 8 -> "committing";
            case 9 -> "rolling back";
            default -> "undefined status";
        };
    }

    public synchronized void finalCleanUp() throws ResourceManagerException {
    }

    public synchronized void notifyFinish() {
        this.finished = true;
        this.notifyAll();
    }

    public abstract void doCommit() throws ResourceManagerException;

    public abstract void doRollback() throws ResourceManagerException;

    public void setStatus(int status) {
        this.status = status;
    }
}

