/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import jakarta.inject.Inject;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.TransformerUtils;
import org.mule.runtime.core.internal.util.StringMessageUtils;

public final class TransformerChain
extends AbstractTransformer {
    private MuleContext muleContext;
    @Inject
    private MuleConfiguration muleConfiguration;
    private final List<Transformer> transformers;

    public TransformerChain(List<Transformer> transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(transformers);
    }

    public TransformerChain(Transformer ... transformers) {
        this(Arrays.asList(transformers));
        this.name = this.generateTransformerName();
        this.setReturnDataType(transformers[transformers.length - 1].getReturnDataType());
    }

    public TransformerChain(String name, List<Transformer> transformers) {
        this(transformers);
        this.name = name;
    }

    public TransformerChain(String name, Transformer ... transformers) {
        this(name, Arrays.asList(transformers));
    }

    @Override
    protected Object doTransform(Object src, Charset enc) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object transform(Object src, Charset enc) throws TransformerException {
        Message message;
        DataType sourceType = DataType.fromType(src.getClass());
        if (!this.isSourceDataTypeSupported(sourceType)) {
            if (this.isIgnoreBadInput()) {
                this.logger.debug("Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return src;
            }
            throw new TransformerException(CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), src.getClass()), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Applying transformer {} ({})", (Object)this.getName(), (Object)this.getClass().getName());
            this.logger.debug("Object before transform: {}", (Object)StringMessageUtils.toString(src));
        }
        if (src instanceof Message) {
            message = (Message)src;
        } else if (this.muleConfiguration.isAutoWrapMessageAwareTransform()) {
            message = Message.of(src);
        } else {
            throw new TransformerException(CoreMessages.noCurrentEventForTransformer(), this);
        }
        Object result = this.transformMessage(message, enc);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Object after transform: %s", StringMessageUtils.toString(result)));
        }
        result = this.checkReturnClass(result);
        return result;
    }

    private Object transformMessage(Message message, Charset outputEncoding) throws TransformerException {
        Message result = message;
        Object temp = message;
        Transformer lastTransformer = null;
        for (Transformer element : this.transformers) {
            lastTransformer = element;
            temp = lastTransformer.transform(temp);
            if (temp instanceof Message) {
                result = (Message)temp;
                continue;
            }
            result = Message.builder(message).value(temp).build();
        }
        if (lastTransformer != null && Message.class.isAssignableFrom(lastTransformer.getReturnDataType().getType())) {
            return result;
        }
        return result.getPayload().getValue();
    }

    private Object checkReturnClass(Object object) throws TransformerException {
        try {
            TransformerUtils.checkTransformerReturnClass(this, object);
        }
        catch (TransformerException e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage(e.getMessage()), this);
        }
        return object;
    }

    @Inject
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.transformers, this.muleContext);
    }

    @Override
    protected String generateTransformerName() {
        Object name = this.transformers.get(0).getClass().getSimpleName();
        int i = ((String)name).indexOf("To");
        DataType dt = this.transformers.get(this.transformers.size() - 1).getReturnDataType();
        if (i > 0 && dt != null) {
            String target = dt.getType().getSimpleName();
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            name = ((String)name).substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return name;
    }

    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }
}

