/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.exporter.api.MeterExporterFactory;
import org.mule.runtime.metrics.exporter.impl.OpenTelemetryMeterExporter;
import org.mule.runtime.metrics.exporter.impl.capturer.CapturingMeterExporterWrapper;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class OpenTelemetryMeterExporterFactory
implements MeterExporterFactory {
    public static final CapturingMeterExporterWrapper METER_SNIFFER_EXPORTER = new CapturingMeterExporterWrapper();
    public static final AttributeKey<String> SERVICE_NAME_KEY = AttributeKey.stringKey((String)"service.name");
    @Inject
    private MuleContext muleContext;
    private final LazyValue<Resource> resource = new LazyValue<Supplier<Resource>>(this::getResource);

    @Override
    public MeterExporter getMeterExporter(ObservabilitySignalConfiguration configuration) {
        return new OpenTelemetryMeterExporter(configuration, this.resource.get());
    }

    private Resource getResource() {
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of(SERVICE_NAME_KEY, (Object)this.getResourceId())));
    }

    protected String getResourceId() {
        return this.muleContext.getConfiguration().getId();
    }
}

