/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.connection;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.config.BaseConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationCreationUtils;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ConnectionProviderObjectFactory<C>
extends AbstractExtensionObjectFactory<ConnectionProviderResolver<C>> {
    private final ConnectionProviderModel providerModel;
    private final ExtensionModel extensionModel;
    private final AuthorizationCodeOAuthHandler authCodeHandler;
    private final ClientCredentialsOAuthHandler clientCredentialsHandler;
    private final PlatformManagedOAuthHandler platformManagedOAuthHandler;
    private PoolingProfile poolingProfile = null;
    private ReconnectionConfig reconnectionConfig = ReconnectionConfig.defaultReconnectionConfig();
    @Inject
    private ConfigurationProperties properties;
    @Inject
    private MuleContext muleContext;

    public ConnectionProviderObjectFactory(ConnectionProviderModel providerModel, ExtensionModel extensionModel, AuthorizationCodeOAuthHandler authCodeHandler, ClientCredentialsOAuthHandler clientCredentialsHandler, PlatformManagedOAuthHandler platformManagedOAuthHandler, MuleContext muleContext) {
        super(muleContext);
        this.providerModel = providerModel;
        this.extensionModel = extensionModel;
        this.authCodeHandler = authCodeHandler;
        this.clientCredentialsHandler = clientCredentialsHandler;
        this.platformManagedOAuthHandler = platformManagedOAuthHandler;
    }

    @Override
    public ConnectionProviderResolver<C> doGetObject() {
        Callable<ResolverSet> callable = () -> this.getParametersResolver().getParametersAsResolverSet(this.providerModel, this.muleContext);
        ResolverSet resolverSet = ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), callable);
        BaseConnectionProviderObjectBuilder builder = this.providerModel.getModelProperty(OAuthModelProperty.class).isPresent() ? ConfigurationCreationUtils.resolveOAuthBuilder(this.extensionModel, this.providerModel, this.poolingProfile, this.reconnectionConfig, this.authCodeHandler, this.clientCredentialsHandler, this.platformManagedOAuthHandler, resolverSet, this.properties, this.expressionManager, this.muleContext, this.artifactEncoding) : new DefaultConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.extensionModel, this.expressionManager, this.muleContext.getErrorTypeRepository(), this.artifactEncoding, this.muleContext.getInjector(), this.muleContext.getExecutionClassLoader());
        return new ConnectionProviderResolver(builder, resolverSet, this.muleContext.getInjector());
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setReconnectionConfig(ReconnectionConfig reconnectionConfig) {
        this.reconnectionConfig = reconnectionConfig;
    }
}

