/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkOptionalParameterModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParser;

class MuleSdkParameterGroupModelParser
extends BaseMuleSdkExtensionModelParser
implements ParameterGroupModelParser {
    private final List<ParameterModelParser> parameters;
    private final Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionals;
    private final ExtensionModelHelper extensionModelHelper;

    public MuleSdkParameterGroupModelParser(ComponentAst parametersComponent, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        this.extensionModelHelper = extensionModelHelper;
        this.parameters = this.doParserParameters(parametersComponent, typeLoader);
        this.exclusiveOptionals = this.doParseExclusiveOptionalDescriptorFromGroup(parametersComponent);
    }

    private List<ParameterModelParser> doParserParameters(ComponentAst parametersComponent, TypeLoader typeLoader) {
        Stream<ParameterModelParser> parameterParsers = this.getChildren(parametersComponent, "parameter").map(p -> new MuleSdkParameterModelParser((ComponentAst)p, typeLoader, this.extensionModelHelper));
        Stream<ParameterModelParser> optionalParameterParsers = this.getChildren(parametersComponent, "optional-parameter").map(p -> new MuleSdkOptionalParameterModelParser((ComponentAst)p, typeLoader, this.extensionModelHelper));
        return Stream.concat(parameterParsers, optionalParameterParsers).collect(Collectors.toList());
    }

    private Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> doParseExclusiveOptionalDescriptorFromGroup(ComponentAst parametersComponent) {
        return this.getSingleChild(parametersComponent, "exclusive-optionals").map(exclusiveOptionals -> this.doParseExclusiveOptionalDescriptor((ComponentAst)exclusiveOptionals));
    }

    private ParameterGroupModelParser.ExclusiveOptionalDescriptor doParseExclusiveOptionalDescriptor(ComponentAst exclusiveOptionals) {
        Set parameters = Stream.of(((String)this.getParameter(exclusiveOptionals, "exclusiveOptionals")).split(",")).map(String::trim).filter(p -> !StringUtils.isBlank((CharSequence)p)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ParameterGroupModelParser.ExclusiveOptionalDescriptor(parameters, this.getOptionalParameter(exclusiveOptionals, "oneRequired").orElse(false));
    }

    @Override
    public String getName() {
        return "General";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public List<ParameterModelParser> getParameterParsers() {
        return this.parameters;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.empty();
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        return Optional.empty();
    }

    @Override
    public Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> getExclusiveOptionals() {
        return this.exclusiveOptionals;
    }

    @Override
    public boolean showsInDsl() {
        return false;
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }
}

