/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationModelTypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModelTypeUtils.class);
    private static final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    private ApplicationModelTypeUtils() {
    }

    public static void resolveTypedComponentIdentifier(final DefaultComponentAstBuilder componentAstBuilder, Optional<ComponentAstBuilder> parent, final ExtensionModelHelper extensionModelHelper) {
        LOGGER.debug("resolveTypedComponentIdentifier for {}", (Object)componentAstBuilder);
        if (componentAstBuilder.getExtensionModel() != null) {
            extensionModelHelper.walkToComponent(componentAstBuilder.getIdentifier(), parent, new ExtensionModelHelper.ExtensionWalkerModelDelegate(){

                @Override
                public void onConfiguration(ConfigurationModel model) {
                    componentAstBuilder.withConfigurationModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
                    componentAstBuilder.withComponentType(TypedComponentIdentifier.ComponentType.CONFIG);
                }

                @Override
                public void onConnectionProvider(ConnectionProviderModel model) {
                    componentAstBuilder.withConnectionProviderModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
                    componentAstBuilder.withComponentType(TypedComponentIdentifier.ComponentType.CONNECTION);
                }

                @Override
                public void onOperation(OperationModel model) {
                    componentAstBuilder.withComponentModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
                    componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(model));
                }

                @Override
                public void onSource(SourceModel model) {
                    componentAstBuilder.withComponentModel(model);
                    ArrayList<ParameterGroupModel> sourceParamGroups = new ArrayList<ParameterGroupModel>(model.getParameterGroupModels());
                    model.getSuccessCallback().ifPresent(scb -> sourceParamGroups.addAll(scb.getParameterGroupModels()));
                    model.getErrorCallback().ifPresent(ecb -> sourceParamGroups.addAll(ecb.getParameterGroupModels()));
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, sourceParamGroups, extensionModelHelper);
                    componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(model));
                }

                @Override
                public void onConstruct(ConstructModel model) {
                    componentAstBuilder.withComponentModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
                    componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(model));
                }

                @Override
                public void onNestableElement(NestableElementModel model) {
                    if (ApplicationModelTypeUtils.handleAsListOfRoutes(model)) {
                        ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
                        componentAstBuilder.childComponentsStream().forEach(child -> this.doOnNestableElement((DefaultComponentAstBuilder)child, model, extensionModelHelper));
                        componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(model));
                    } else {
                        this.doOnNestableElement(componentAstBuilder, model, extensionModelHelper);
                    }
                }

                private void doOnNestableElement(DefaultComponentAstBuilder component, NestableElementModel model, ExtensionModelHelper extensionModelHelper2) {
                    component.withNestableElementModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(component, model, model.getParameterGroupModels(), extensionModelHelper2);
                    component.withComponentType(extensionModelHelper2.findComponentType(model));
                }

                @Override
                public void onType(MetadataType type) {
                    type.accept(new MetadataTypeVisitor(){

                        @Override
                        public void visitObject(ObjectType objectType) {
                            componentAstBuilder.withTypedModel(objectType);
                            componentAstBuilder.getModel(ParameterizedModel.class).ifPresent(model -> ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper));
                        }

                        @Override
                        public void visitArrayType(ArrayType arrayType) {
                            arrayType.getType().accept(this);
                        }

                        @Override
                        public void visitUnion(UnionType unionType) {
                            unionType.getTypes().forEach(type -> type.accept(this));
                        }
                    });
                }
            }, componentAstBuilder.getExtensionModel());
        }
        if (!componentAstBuilder.getModel(HasStereotypeModel.class).isPresent()) {
            InfrastructureTypeUtils.getTypeFor(componentAstBuilder.getIdentifier()).flatMap(extensionModelHelper::findMetadataType).ifPresent(type -> {
                componentAstBuilder.withTypedModel((MetadataType)type);
                ParameterizedModel model = componentAstBuilder.getModel(ParameterizedModel.class).get();
                ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, model, model.getParameterGroupModels(), extensionModelHelper);
            });
        }
        if (componentAstBuilder.getModel(HasStereotypeModel.class).map(st -> st.getStereotype() != null && st.getStereotype().isAssignableTo(MuleStereotypes.CONFIG)).orElse(false).booleanValue()) {
            componentAstBuilder.withComponentType(TypedComponentIdentifier.ComponentType.CONFIG);
        } else if (componentAstBuilder.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)) {
            componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(componentAstBuilder.getIdentifier()));
        }
    }

    private static boolean handleAsListOfRoutes(NestableElementModel model) {
        return model instanceof NestedRouteModel && ExtensionModelUtils.supportsMultiple((NestedRouteModel)model) && model.getNestedComponents().stream().noneMatch(nc -> nc.getModelProperty(NoWrapperModelProperty.class).isPresent());
    }

    private static void onParameterizedModel(DefaultComponentAstBuilder component, NamedObject model, List<ParameterGroupModel> paramGroups, ExtensionModelHelper extensionModelHelper) {
        DslElementSyntax elementDsl;
        LOGGER.debug("onParameterizedModel: {}", (Object)model.getName());
        if (component.getType() != null) {
            elementDsl = component.getGenerationInformation().getSyntax();
        } else {
            elementDsl = extensionModelHelper.resolveDslElementModel(model, component.getIdentifier());
            component.getGenerationInformation().withSyntax(elementDsl);
        }
        LOGGER.trace("onParameterizedModel.elementDsl: {}", (Object)elementDsl);
        MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents = ApplicationModelTypeUtils.getNestedComponents(component);
        List inlineGroupedParameters = paramGroups.stream().filter(ParameterGroupModel::isShowInDsl).map(group -> ApplicationModelTypeUtils.addInlineGroup(component, nestedComponents, group, extensionModelHelper)).flatMap(k -> k.getParameterModels().stream().map(v -> new Pair<ParameterModel, ParameterGroupModel>((ParameterModel)v, (ParameterGroupModel)k))).collect(Collectors.toList());
        List<Pair<ParameterModel, ParameterGroupModel>> parameters = paramGroups.stream().flatMap(k -> k.getParameterModels().stream().map(v -> new Pair<ParameterModel, ParameterGroupModel>((ParameterModel)v, (ParameterGroupModel)k))).distinct().collect(Collectors.toList());
        parameters.stream().filter(paramModel -> !inlineGroupedParameters.contains(paramModel)).forEach(paramModel -> elementDsl.getAttribute(((ParameterModel)paramModel.getFirst()).getName()).ifPresent(attrDsl -> {
            if (ApplicationModelTypeUtils.setSimpleParameterValue(component, component, (ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), attrDsl, nestedComponents)) {
                inlineGroupedParameters.add(paramModel);
            }
        }));
        ApplicationModelTypeUtils.handleNestedParameters(component, nestedComponents, extensionModelHelper, parameters, parameterModel -> !inlineGroupedParameters.contains(parameterModel));
    }

    private static ParameterGroupModel addInlineGroup(DefaultComponentAstBuilder component, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, ParameterGroupModel group, ExtensionModelHelper extensionModelHelper) {
        component.getGenerationInformation().getSyntax().getChild(group.getName()).ifPresent(groupDsl -> {
            Optional<ComponentIdentifier> groupIdentifier = ApplicationModelTypeUtils.getIdentifier(groupDsl);
            if (!groupIdentifier.isPresent()) {
                return;
            }
            DefaultComponentAstBuilder groupComponent = ApplicationModelTypeUtils.getSingleComponentModel(nestedComponents, groupIdentifier);
            if (groupComponent != null) {
                groupComponent.getGenerationInformation().withSyntax((DslElementSyntax)groupDsl);
                ArrayList inlineGroupedParameters = new ArrayList();
                group.getParameterModels().stream().filter(paramModel -> groupComponent.getRawParameters().containsKey(paramModel.getName())).forEach(paramModel -> groupDsl.getAttribute(paramModel.getName()).ifPresent(attr -> {
                    if (ApplicationModelTypeUtils.setSimpleParameterValue(component, groupComponent, paramModel, group, attr, nestedComponents)) {
                        inlineGroupedParameters.add(new Pair<ParameterModel, ParameterGroupModel>((ParameterModel)paramModel, group));
                    }
                }));
                ApplicationModelTypeUtils.handleNestedParameters(component, ApplicationModelTypeUtils.getNestedComponents(groupComponent), extensionModelHelper, group.getParameterModels().stream().map(k -> new Pair<ParameterModel, ParameterGroupModel>((ParameterModel)k, group)).collect(Collectors.toList()), parameterModel -> !inlineGroupedParameters.contains(parameterModel));
            }
        });
        return group;
    }

    private static void handleNestedParameters(DefaultComponentAstBuilder component, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, ExtensionModelHelper extensionModelHelper, List<Pair<ParameterModel, ParameterGroupModel>> parameters, Predicate<Pair<ParameterModel, ParameterGroupModel>> parameterModelFilter) {
        parameters.stream().filter(parameterModelFilter).filter(paramModel -> ((ParameterModel)paramModel.getFirst()).getDslConfiguration() != null && ((ParameterModel)paramModel.getFirst()).getDslConfiguration().allowsInlineDefinition()).forEach(paramModel -> {
            DslElementSyntax paramSyntax = extensionModelHelper.resolveDslElementModel((ParameterModel)paramModel.getFirst(), component.getIdentifier());
            ApplicationModelTypeUtils.getIdentifier(paramSyntax).ifPresent(id -> ApplicationModelTypeUtils.handleNestedExtensionParameter(component, nestedComponents, extensionModelHelper, paramModel, paramSyntax, nestedComponents.getAll(id)));
        });
    }

    private static void handleNestedExtensionParameter(final DefaultComponentAstBuilder component, final MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, final ExtensionModelHelper extensionModelHelper, final Pair<ParameterModel, ParameterGroupModel> paramModel, final DslElementSyntax paramSyntax, final Collection<DefaultComponentAstBuilder> nestedForId) {
        LOGGER.debug("handleNestedExtensionParameter: {} - {}.{}", new Object[]{component.getIdentifier(), paramModel.getSecond().getName(), paramModel.getFirst().getName()});
        paramModel.getFirst().getType().accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (ExtensionModelUtils.isContent((ParameterModel)paramModel.getFirst()) || ((ParameterModel)paramModel.getFirst()).getExpressionSupport() == ExpressionSupport.REQUIRED) {
                    this.addParameterUsingTextContent(component, nestedForId);
                } else {
                    ApplicationModelTypeUtils.enrichComponentModels(component, nestedComponents, Optional.of(paramSyntax), (ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), metadataType, true, extensionModelHelper);
                }
            }

            @Override
            public void visitUnion(UnionType unionType) {
                if (ExtensionModelUtils.isContent((ParameterModel)paramModel.getFirst()) || ((ParameterModel)paramModel.getFirst()).getExpressionSupport() == ExpressionSupport.REQUIRED) {
                    this.addParameterUsingTextContent(component, nestedForId);
                } else {
                    unionType.getTypes().forEach(type -> type.accept(this));
                }
            }

            @Override
            public void visitSimpleType(SimpleType stringType) {
                this.addParameterUsingTextContent(component, nestedForId);
            }

            private void addParameterUsingTextContent(DefaultComponentAstBuilder componentModel, Collection<DefaultComponentAstBuilder> nestedForId2) {
                nestedForId2.forEach(childComp -> componentModel.addParameter((ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), configurer -> {
                    String body = childComp.getRawParameters().get("$%body%$");
                    body = body == null ? this.resolveNullBody((DefaultComponentAstBuilder)childComp) : this.resolveNonNullBody(body, (DefaultComponentAstBuilder)childComp);
                    configurer.withSyntax(paramSyntax).withMetadata(childComp.getMetadata()).withValue(body);
                }));
            }

            private String resolveNullBody(DefaultComponentAstBuilder childComp) {
                if (ApplicationModelTypeUtils.isCdata(childComp)) {
                    return "";
                }
                return null;
            }

            private String resolveNonNullBody(String body, DefaultComponentAstBuilder childComp) {
                if (ApplicationModelTypeUtils.isCdata(childComp)) {
                    return body;
                }
                return body.trim();
            }
        });
    }

    private static MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> getNestedComponents(DefaultComponentAstBuilder component) {
        MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> result = new MultiMap<ComponentIdentifier, DefaultComponentAstBuilder>();
        component.childComponentsStream().forEach(nestedComponent -> result.put(nestedComponent.getIdentifier(), (DefaultComponentAstBuilder)nestedComponent));
        return result;
    }

    private static DefaultComponentAstBuilder getSingleComponentModel(MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(innerComponents::containsKey).map(innerComponents::getAll).map(collection -> (DefaultComponentAstBuilder)collection.iterator().next()).orElse(null);
    }

    private static boolean enrichComponentModels(DefaultComponentAstBuilder component, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<DslElementSyntax> optionalParamDsl, ParameterModel paramModel, ParameterGroupModel parameterGroupModel, MetadataType paramConcreteType, ExtensionModelHelper extensionModelHelper) {
        return ApplicationModelTypeUtils.enrichComponentModels(component, innerComponents, optionalParamDsl, paramModel, parameterGroupModel, paramConcreteType, false, extensionModelHelper);
    }

    private static boolean enrichComponentModels(DefaultComponentAstBuilder component, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<DslElementSyntax> optionalParamDsl, ParameterModel paramModel, ParameterGroupModel parameterGroupModel, MetadataType paramConcreteType, boolean useConcreteTypeForUnion, ExtensionModelHelper extensionModelHelper) {
        if (!optionalParamDsl.isPresent()) {
            return false;
        }
        DslElementSyntax paramDsl = optionalParamDsl.get();
        DefaultComponentAstBuilder paramComponent = null;
        if (!ApplicationModelTypeUtils.isNoWrapperParam(paramModel)) {
            paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl));
            if (paramComponent == null && component.getIdentifier() != null) {
                paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl.getElementName(), component.getIdentifier().getNamespace()));
            }
            if (paramComponent == null && !StringUtils.isEmpty((CharSequence)paramDsl.getPrefix())) {
                paramDsl = extensionModelHelper.resolveDslElementModel(paramConcreteType, paramDsl.getPrefix()).orElse(paramDsl);
                paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl));
            }
        }
        if (ApplicationModelTypeUtils.isNoWrapperParam(paramModel)) {
            paramModel.getType().accept(ApplicationModelTypeUtils.getComponentChildVisitor(component, paramModel, parameterGroupModel, paramDsl, paramDsl, component, extensionModelHelper, innerComponents));
            return true;
        }
        if (paramComponent != null) {
            paramComponent.getGenerationInformation().withSyntax(paramDsl);
            if (paramDsl.isWrapped()) {
                ApplicationModelTypeUtils.handleWrappedElement(component, paramComponent, paramModel, parameterGroupModel, paramConcreteType, useConcreteTypeForUnion, paramDsl, extensionModelHelper);
            } else {
                paramModel.getType().accept(ApplicationModelTypeUtils.getComponentChildVisitor(component, paramModel, parameterGroupModel, paramDsl, paramDsl, paramComponent, extensionModelHelper, innerComponents));
            }
            return true;
        }
        return ApplicationModelTypeUtils.setSimpleParameterValue(component, component, paramModel, parameterGroupModel, optionalParamDsl.get(), innerComponents);
    }

    private static boolean isNoWrapperParam(ParameterModel paramModel) {
        return paramModel.getModelProperty(NoWrapperModelProperty.class).isPresent();
    }

    private static void handleWrappedElement(final DefaultComponentAstBuilder component, DefaultComponentAstBuilder wrappedComponent, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, final MetadataType paramConcreteType, final boolean useConcreteTypeForUnion, final DslElementSyntax paramDsl, final ExtensionModelHelper extensionModelHelper) {
        final MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedWrappedComponents = ApplicationModelTypeUtils.getNestedComponents(wrappedComponent);
        LOGGER.debug("handleWrappedElement: {} - {}.{}", new Object[]{component.getIdentifier(), parameterGroupModel.getName(), paramModel.getName()});
        paramModel.getType().accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                extensionModelHelper.resolveSubTypes(objectType).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent() && ApplicationModelTypeUtils.getSingleComponentModel(nestedWrappedComponents, ApplicationModelTypeUtils.getIdentifier((DslElementSyntax)((Optional)entry.getValue()).get())) != null).findFirst().ifPresent(wrappedEntryType -> {
                    DslElementSyntax wrappedDsl = (DslElementSyntax)((Optional)wrappedEntryType.getValue()).get();
                    ((ObjectType)wrappedEntryType.getKey()).accept(ApplicationModelTypeUtils.getComponentChildVisitor(component, paramModel, parameterGroupModel, paramDsl, wrappedDsl, ApplicationModelTypeUtils.getSingleComponentModel(nestedWrappedComponents, ApplicationModelTypeUtils.getIdentifier(wrappedDsl)), extensionModelHelper, nestedWrappedComponents));
                });
            }

            @Override
            public void visitUnion(UnionType unionType) {
                if (useConcreteTypeForUnion) {
                    this.doVisitUnionType(paramConcreteType);
                } else {
                    unionType.getTypes().forEach(this::doVisitUnionType);
                }
            }

            private void doVisitUnionType(MetadataType type) {
                MetadataTypeUtils.getTypeId(type).flatMap(paramDsl::getChild).flatMap(x$0 -> ApplicationModelTypeUtils.getIdentifier(x$0)).map(nestedWrappedComponents::getAll).orElse(Collections.emptyList()).forEach(nestedChild -> type.accept(ApplicationModelTypeUtils.getComponentChildVisitor(component, paramModel, parameterGroupModel, paramDsl, paramDsl, nestedChild, extensionModelHelper, nestedWrappedComponents)));
            }
        });
    }

    private static boolean setSimpleParameterValue(DefaultComponentAstBuilder componentTo, DefaultComponentAstBuilder componentFrom, ParameterModel paramModel, ParameterGroupModel paramGroupModel, DslElementSyntax paramDsl, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        Object annotationValue;
        String value = null;
        if (paramDsl.supportsAttributeDeclaration() && (value = componentFrom.getRawParameters().get(ApplicationModelTypeUtils.getInfrastructureParameterName(paramModel.getType()).orElse(paramModel.getName()))) == null && paramDsl.getNamespace() != null && (annotationValue = componentFrom.getAnnotations().get("{" + paramDsl.getNamespace() + "}" + paramDsl.getAttributeName())) != null) {
            value = annotationValue.toString();
        }
        Optional<ComponentIdentifier> paramIdentifier = Optional.empty();
        if (StringUtils.isBlank(value) && ExtensionModelUtils.isContent(paramModel)) {
            value = componentFrom.getRawParameters().get("$%body%$");
            paramIdentifier = Optional.of(componentFrom.getIdentifier());
        }
        if (StringUtils.isNotBlank(value)) {
            if (ExtensionModelUtils.isContent(paramModel) && !ApplicationModelTypeUtils.isCdata(componentFrom)) {
                value = value.trim();
            }
            DefaultComponentParameterAst paramValue = new DefaultComponentParameterAst(value, paramModel, paramGroupModel, componentFrom.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentFrom.getPropertiesResolver(), componentFrom.getParameterModelUtils());
            Optional<ComponentIdentifier> childParamId = ApplicationModelTypeUtils.getIdentifier(paramDsl);
            if (childParamId.map(nestedComponents::containsKey).orElse(false).booleanValue()) {
                if (paramValue.isDefaultValue()) {
                    return false;
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("[%s:%d]: Component '%s' has a child element '%s' which is used for the same purpose of the configuration parameter '%s'. Only one must be used.", componentTo.getMetadata().getFileName().orElse("unknown"), componentTo.getMetadata().getStartLine().orElse(-1), componentFrom.getIdentifier(), childParamId.get(), paramModel.getName())));
            }
            componentTo.withParameter(paramModel, paramGroupModel, (ComponentParameterAst)paramValue, paramIdentifier);
            return true;
        }
        return false;
    }

    private static MetadataTypeVisitor getComponentChildVisitor(final DefaultComponentAstBuilder component, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, DslElementSyntax paramDsl, final DslElementSyntax paramValueDsl, final DefaultComponentAstBuilder paramComponent, final ExtensionModelHelper extensionModelHelper, final MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitSimpleType(SimpleType simpleType) {
                DefaultComponentAstBuilder paramComponentFrom = ApplicationModelTypeUtils.getSingleComponentModel(nestedComponents, ApplicationModelTypeUtils.getIdentifier(paramValueDsl));
                ApplicationModelTypeUtils.setSimpleParameterValue(component, paramComponentFrom, paramModel, parameterGroupModel, paramValueDsl, ApplicationModelTypeUtils.getNestedComponents(paramComponentFrom));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                MetadataType itemType = arrayType.getType();
                itemType.accept(ApplicationModelTypeUtils.getArrayItemTypeVisitor(component, paramModel, parameterGroupModel, paramValueDsl, paramComponent, extensionModelHelper));
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    List componentModels = ApplicationModelTypeUtils.handleMapChild(paramModel, paramValueDsl, paramComponent, extensionModelHelper, objectType);
                    component.addParameter(paramModel, parameterGroupModel, configurer -> configurer.withSyntax(paramValueDsl).withMetadata(paramComponent.getMetadata()).withValue(componentModels));
                    if (ApplicationModelTypeUtils.isNoWrapperParam(paramModel)) {
                        componentModels.forEach(cm -> component.removeChildComponent((DefaultComponentAstBuilder)cm));
                    }
                    return;
                }
                component.addParameter(paramModel, parameterGroupModel, configurer -> configurer.withSyntax(paramValueDsl).withMetadata(paramComponent.getMetadata()).withValue(paramComponent));
                ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, objectType, paramComponent.getIdentifier());
                paramComponent.withParameterizedModel(parameterizedModel);
                paramComponent.getGenerationInformation().withSyntax(paramValueDsl);
                final MultiMap nestedComponents2 = ApplicationModelTypeUtils.getNestedComponents(paramComponent);
                parameterizedModel.getParameterGroupModels().forEach(nestedGroup -> nestedGroup.getParameterModels().forEach(nestedParameter -> {
                    if (!ApplicationModelTypeUtils.enrichComponentModels(paramComponent, nestedComponents2, paramValueDsl.getContainedElement(nestedParameter.getName()), nestedParameter, nestedGroup, nestedParameter.getType(), extensionModelHelper)) {
                        nestedParameter.getType().accept(new MetadataTypeVisitor((ParameterModel)nestedParameter, (ParameterGroupModel)nestedGroup){
                            final /* synthetic */ ParameterModel val$nestedParameter;
                            final /* synthetic */ ParameterGroupModel val$nestedGroup;
                            {
                                this.val$nestedParameter = parameterModel;
                                this.val$nestedGroup = parameterGroupModel;
                            }

                            @Override
                            public void visitUnion(UnionType unionType) {
                                unionType.getTypes().forEach(type -> ApplicationModelTypeUtils.enrichComponentModels(paramComponent, nestedComponents2, extensionModelHelper.resolveDslElementModel((MetadataType)type, paramValueDsl.getPrefix()), this.val$nestedParameter, this.val$nestedGroup, this.val$nestedParameter.getType(), extensionModelHelper));
                            }
                        });
                    }
                }));
            }

            @Override
            public void visitUnion(UnionType unionType) {
                component.addParameter(paramModel, parameterGroupModel, configurer -> configurer.withSyntax(paramValueDsl).withMetadata(paramComponent.getMetadata()).withValue(paramComponent));
                MultiMap nestedComponents2 = ApplicationModelTypeUtils.getNestedComponents(paramComponent);
                unionType.getTypes().forEach(type -> {
                    ParameterizedModel innerTypeParameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                    if (paramValueDsl.isWrapped()) {
                        paramValueDsl.getContainedElement(NameUtils.getAliasName(type)).ifPresent(innerParamDsl -> {
                            ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                            paramComponent.withParameterizedModel(parameterizedModel);
                            ExtensionModelUtils.getGroupAndParametersPairs(innerTypeParameterizedModel).forEach(groupAndParam -> {
                                Collection children = ApplicationModelTypeUtils.getIdentifier(innerParamDsl).map(nestedComponents2::getAll).orElse(Collections.emptyList());
                                children.forEach(nested -> {
                                    nested.withParameterizedModel(innerTypeParameterizedModel);
                                    ApplicationModelTypeUtils.enrichComponentModels(nested, ApplicationModelTypeUtils.getNestedComponents(nested), innerParamDsl.getContainedElement(((ParameterModel)groupAndParam.getSecond()).getName()), (ParameterModel)groupAndParam.getSecond(), (ParameterGroupModel)groupAndParam.getFirst(), ((ParameterModel)groupAndParam.getSecond()).getType(), extensionModelHelper);
                                });
                            });
                        });
                    } else if (paramComponent.getIdentifier().getName().equals(innerTypeParameterizedModel.getName())) {
                        ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                        paramComponent.withParameterizedModel(parameterizedModel);
                        ExtensionModelUtils.getGroupAndParametersPairs(innerTypeParameterizedModel).forEach(groupAndParam -> {
                            Optional<DslElementSyntax> containedElement = paramValueDsl.getContainedElement(((ParameterModel)groupAndParam.getSecond()).getName());
                            ApplicationModelTypeUtils.enrichComponentModels(paramComponent, nestedComponents2, containedElement, (ParameterModel)groupAndParam.getSecond(), (ParameterGroupModel)groupAndParam.getFirst(), ((ParameterModel)groupAndParam.getSecond()).getType(), extensionModelHelper);
                        });
                    }
                });
            }
        };
    }

    private static List<ComponentAstBuilder> handleMapChild(ParameterModel paramModel, DslElementSyntax paramDsl, DefaultComponentAstBuilder paramComponent, ExtensionModelHelper extensionModelHelper, ObjectType objectType) {
        return paramComponent.childComponentsStream().filter(entryComponent -> {
            MetadataType entryType = objectType.getOpenRestriction().get();
            Optional<DslElementSyntax> entryValueDslOptional = paramDsl.getGeneric(entryType);
            if (entryValueDslOptional.isPresent() || ApplicationModelTypeUtils.isNoWrapperParam(paramModel)) {
                DslElementSyntax entryValueDsl = entryValueDslOptional.isPresent() ? entryValueDslOptional.get() : paramDsl;
                entryComponent.getGenerationInformation().withSyntax(entryValueDsl);
                ParameterDslConfiguration mapEntryAttributesParameterDslConfiguration = ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowsReferences(false).allowTopLevelDefinition(false).build();
                ImmutableParameterModel keyParamModel = new ImmutableParameterModel("key", "", typeLoader.load((Type)((Object)String.class)), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, mapEntryAttributesParameterDslConfiguration, null, null, null, Collections.emptyList(), Collections.emptySet());
                ImmutableParameterModel valueParamModel = new ImmutableParameterModel("value", "", entryType, false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, mapEntryAttributesParameterDslConfiguration, null, null, null, Collections.emptyList(), Collections.emptySet());
                ImmutableParameterGroupModel keyMapEntryGroupModel = new ImmutableParameterGroupModel("General", "", Arrays.asList(keyParamModel, valueParamModel), Collections.emptyList(), false, null, null, Collections.emptySet());
                String key = entryComponent.getRawParameters().get("key");
                entryComponent.addParameter(keyParamModel, keyMapEntryGroupModel, configurer -> {
                    entryValueDsl.getAttribute("key").ifPresent(configurer::withSyntax);
                    configurer.withMetadata(entryComponent.getMetadata()).withValue(key);
                });
                String value = entryComponent.getRawParameters().get("value");
                if (StringUtils.isBlank((CharSequence)value)) {
                    Optional<DslElementSyntax> genericValueDslOptional = entryValueDsl.getGeneric(keyParamModel.getType());
                    MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents = ApplicationModelTypeUtils.getNestedComponents(entryComponent);
                    if (genericValueDslOptional.isPresent()) {
                        DslElementSyntax genericValueDsl = genericValueDslOptional.get();
                        List itemsComponentModels = entryComponent.childComponentsStream().filter(valueComponent -> valueComponent.getIdentifier().equals(ApplicationModelTypeUtils.getIdentifier(genericValueDsl).orElse(null))).map(entryValueComponent -> {
                            MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nested = new MultiMap<ComponentIdentifier, DefaultComponentAstBuilder>();
                            nested.put(entryValueComponent.getIdentifier(), (DefaultComponentAstBuilder)entryValueComponent);
                            ApplicationModelTypeUtils.enrichComponentModels(entryComponent, nested, Optional.of(genericValueDsl), valueParamModel, keyMapEntryGroupModel, valueParamModel.getType(), extensionModelHelper);
                            return entryValueComponent;
                        }).collect(Collectors.toList());
                        entryComponent.addParameter(valueParamModel, keyMapEntryGroupModel, configurer -> {
                            entryValueDsl.getAttribute("value").ifPresent(configurer::withSyntax);
                            configurer.withMetadata(entryComponent.getMetadata()).withValue(itemsComponentModels);
                        });
                    } else {
                        ApplicationModelTypeUtils.handleLaxMapEntry(extensionModelHelper, entryComponent, entryType, entryValueDsl, valueParamModel, keyMapEntryGroupModel, mapEntryAttributesParameterDslConfiguration, nestedComponents);
                    }
                } else {
                    entryComponent.addParameter(valueParamModel, keyMapEntryGroupModel, configurer -> {
                        entryValueDsl.getAttribute("value").ifPresent(configurer::withSyntax);
                        configurer.withMetadata(entryComponent.getMetadata()).withValue(value);
                    });
                }
                entryComponent.withParameterizedModel(MetadataTypeModelAdapter.createKeyValueWrapperTypeModelAdapter(keyParamModel.getName(), keyParamModel.getType(), valueParamModel.getName(), valueParamModel.getType(), extensionModelHelper));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private static void handleLaxMapEntry(ExtensionModelHelper extensionModelHelper, DefaultComponentAstBuilder entryComponent, MetadataType entryType, DslElementSyntax entryValueDsl, ParameterModel valueParamModel, ParameterGroupModel parameterGroupModel, ParameterDslConfiguration mapEntryAttributesParameterDslConfiguration, MultiMap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        Optional<DslElementSyntax> valueDslElementOptional = entryValueDsl.getContainedElement("value");
        if (valueDslElementOptional.isPresent() && !valueDslElementOptional.get().isWrapped()) {
            ApplicationModelTypeUtils.enrichComponentModels(entryComponent, nestedComponents, valueDslElementOptional, valueParamModel, parameterGroupModel, valueParamModel.getType(), extensionModelHelper);
        } else if (entryType instanceof ObjectType) {
            extensionModelHelper.resolveSubTypes((ObjectType)entryType).entrySet().stream().filter(entrySubTypeDslOptional -> ((Optional)entrySubTypeDslOptional.getValue()).isPresent()).forEach(entrySubTypeDslOptional -> ApplicationModelTypeUtils.enrichComponentModels(entryComponent, nestedComponents, Optional.of((DslElementSyntax)((Optional)entrySubTypeDslOptional.getValue()).get()), new ImmutableParameterModel("value", "", (MetadataType)entrySubTypeDslOptional.getKey(), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, mapEntryAttributesParameterDslConfiguration, null, null, null, Collections.emptyList(), Collections.emptySet()), parameterGroupModel, (MetadataType)entrySubTypeDslOptional.getKey(), extensionModelHelper));
        }
    }

    private static MetadataTypeVisitor getArrayItemTypeVisitor(final DefaultComponentAstBuilder componentModel, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, final DslElementSyntax paramDsl, final DefaultComponentAstBuilder paramComponent, final ExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitSimpleType(SimpleType simpleType) {
                if (paramComponent.getRawParameters().containsKey("value")) {
                    paramComponent.withTypedModel(simpleType);
                    return;
                }
                paramDsl.getGeneric(simpleType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ApplicationModelTypeUtils.getIdentifier(itemDsl).get();
                    List componentModels = paramComponent.childComponentsStream().filter(c -> c.getIdentifier().equals(itemIdentifier)).filter(valueComponentModel -> valueComponentModel.getRawParameters().containsKey("value")).peek(valueComponentModel -> {
                        valueComponentModel.withTypedModel(simpleType);
                        valueComponentModel.getGenerationInformation().withSyntax((DslElementSyntax)itemDsl);
                    }).collect(Collectors.toList());
                    componentModel.addParameter(paramModel, parameterGroupModel, configurer -> configurer.withSyntax(paramDsl).withMetadata(paramComponent.getMetadata()).withValue(componentModels));
                });
            }

            @Override
            public void visitObject(ObjectType itemType) {
                paramDsl.getGeneric(itemType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ApplicationModelTypeUtils.getIdentifier(itemDsl).get();
                    HashMap objectTypeByTypeId = new HashMap();
                    HashMap typesDslMap = new HashMap();
                    HashMap itemIdentifiers = new HashMap();
                    LOGGER.debug("getArrayItemTypeVisitor.visitObject: visiting itemType '{}'.", (Object)itemType);
                    extensionModelHelper.resolveSubTypes(itemType).entrySet().stream().forEach(entry -> MetadataTypeUtils.getTypeId((MetadataType)entry.getKey()).ifPresent(subTypeTypeId -> {
                        typesDslMap.put(subTypeTypeId, (Optional)entry.getValue());
                        objectTypeByTypeId.put(subTypeTypeId, (ObjectType)entry.getKey());
                        ((Optional)entry.getValue()).ifPresent(dslElementSyntax -> ApplicationModelTypeUtils.getIdentifier(dslElementSyntax).ifPresent(subTypeIdentifier -> itemIdentifiers.put(subTypeIdentifier, subTypeTypeId)));
                    }));
                    MetadataTypeUtils.getTypeId(itemType).ifPresent(itemTypeId -> {
                        typesDslMap.putIfAbsent(itemTypeId, Optional.of(itemDsl));
                        objectTypeByTypeId.putIfAbsent(itemTypeId, itemType);
                        itemIdentifiers.putIfAbsent(itemIdentifier, itemTypeId);
                    });
                    LOGGER.debug("getArrayItemTypeVisitor.visitObject: itemIdentifiers: '{}'.", itemIdentifiers);
                    List componentModels = paramComponent.childComponentsStream().filter(c -> itemIdentifiers.containsKey(c.getIdentifier())).peek(itemComponent -> {
                        String typeId = (String)itemIdentifiers.get(itemComponent.getIdentifier());
                        ((Optional)typesDslMap.get(typeId)).ifPresent(subTypeDsl -> {
                            ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, (MetadataType)objectTypeByTypeId.get(typeId), itemComponent.getIdentifier());
                            itemComponent.withParameterizedModel(parameterizedModel);
                            itemComponent.getGenerationInformation().withSyntax((DslElementSyntax)subTypeDsl);
                            MultiMap nestedComponents = ApplicationModelTypeUtils.getNestedComponents(itemComponent);
                            parameterizedModel.getParameterGroupModels().forEach(nestedGroup -> nestedGroup.getParameterModels().forEach(nestedParameter -> ApplicationModelTypeUtils.enrichComponentModels(itemComponent, nestedComponents, this.recursiveAwareContainedElement(typesDslMap, (DslElementSyntax)subTypeDsl, (ParameterModel)nestedParameter), nestedParameter, nestedGroup, nestedParameter.getType(), extensionModelHelper)));
                        });
                    }).collect(Collectors.toList());
                    componentModel.addParameter(paramModel, parameterGroupModel, configurer -> configurer.withSyntax(paramDsl).withMetadata(paramComponent.getMetadata()).withValue(componentModels));
                });
            }

            private Optional<DslElementSyntax> recursiveAwareContainedElement(Map<String, Optional<DslElementSyntax>> typesDslMap, DslElementSyntax subTypeDsl, ParameterModel nestedParameter) {
                return subTypeDsl.getContainedElement(nestedParameter.getName()).map(innerElement -> MetadataTypeUtils.getTypeId(nestedParameter.getType()).flatMap(typeId -> {
                    if (typesDslMap.containsKey(typeId)) {
                        LOGGER.debug("getArrayItemTypeVisitor.recursiveAwareContainedElement: No entry for '{}' in typesDslMap, ignoring.", typeId);
                        return (Optional)typesDslMap.get(typeId);
                    }
                    return Optional.empty();
                }).map(referencedDslElement -> {
                    LOGGER.debug("getArrayItemTypeVisitor.recursiveAwareContainedElement: processing typeId {}", referencedDslElement);
                    DslElementSyntaxBuilder baseReferenced = DslElementSyntaxBuilder.create().withAttributeName(innerElement.getAttributeName()).withElementName(innerElement.getElementName()).withNamespace(innerElement.getPrefix(), innerElement.getNamespace()).requiresConfig(innerElement.requiresConfig()).supportsAttributeDeclaration(innerElement.supportsAttributeDeclaration()).supportsChildDeclaration(innerElement.supportsChildDeclaration()).supportsTopLevelDeclaration(innerElement.supportsTopLevelDeclaration()).asWrappedElement(innerElement.isWrapped());
                    referencedDslElement.getContainedElementsByName().forEach(baseReferenced::containing);
                    referencedDslElement.getGenerics().forEach(baseReferenced::withGeneric);
                    return baseReferenced.build();
                }).orElse((DslElementSyntax)innerElement));
            }
        };
    }

    private static ParameterizedModel resolveParameterizedModel(ExtensionModelHelper extensionModelHelper, MetadataType type, ComponentIdentifier identifier) {
        return extensionModelHelper.findComponentModel(identifier).map(ParameterizedModel.class::cast).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(type, extensionModelHelper));
    }

    private static Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        return ApplicationModelTypeUtils.getIdentifier(dsl.getElementName(), dsl.getPrefix());
    }

    private static Optional<ComponentIdentifier> getIdentifier(String elementName, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)elementName) && StringUtils.isNotBlank((CharSequence)prefix)) {
            return Optional.of(ComponentIdentifier.builder().name(elementName).namespace(prefix).build());
        }
        return Optional.empty();
    }

    private static Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return InfrastructureTypeUtils.getInfrastructureParameterName(fieldType);
    }

    private static boolean isCdata(DefaultComponentAstBuilder childComp) {
        return Boolean.TRUE.equals(childComp.getMetadata().getParserAttributes().get("IS_CDATA"));
    }
}

