/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.IgnoreOnLazyInit;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

@IgnoreOnLazyInit(forceDslDeclarationValidation=true)
public class ParameterGroupExclusiveness
implements Validation {
    @Override
    public String getName() {
        return "ExclusiveOptionals annotation is honored.";
    }

    @Override
    public String getDescription() {
        return "ExclusiveOptionals annotation is honored.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getModel(ParameterizedModel.class).map(pmzd -> this.resolveGroups((ParameterizedModel)pmzd).stream().anyMatch(pmg -> !pmg.getExclusiveParametersModels().isEmpty())).orElse(false));
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmzd -> this.validate(component, artifact, (ParameterizedModel)pmzd)).orElse(Collections.emptyList());
    }

    protected List<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact, ParameterizedModel pmzd) {
        for (ParameterGroupModel group : this.resolveGroups(pmzd)) {
            for (ExclusiveParametersModel exclusiveModel : group.getExclusiveParametersModels()) {
                Collection definedExclusiveParameters = exclusiveModel.getExclusiveParameterNames().stream().filter(exclParamName -> {
                    ComponentParameterAst value = component.getParameter(group.getName(), (String)exclParamName);
                    return value != null && value.getValue().getValue().isPresent();
                }).collect(Collectors.toList());
                if (definedExclusiveParameters.isEmpty() && exclusiveModel.isOneRequired()) {
                    return Collections.singletonList(ValidationResultItem.create(component, (Validation)this, String.format("Element <%s> requires that one of its optional parameters must be set, but all of them are missing. One of the following must be set: [%s].", group.getName(), exclusiveModel.getExclusiveParameterNames().stream().collect(Collectors.joining(", ")))));
                }
                if (definedExclusiveParameters.size() <= 1) continue;
                return Collections.singletonList(ValidationResultItem.create(component, definedExclusiveParameters.stream().map(param -> component.getParameter(group.getName(), (String)param)).collect(Collectors.toList()), (Validation)this, String.format("Element <%s>, the following parameters cannot be set at the same time: [%s].", NameUtils.getModelName(pmzd), definedExclusiveParameters.stream().collect(Collectors.joining(", ")))));
            }
        }
        return ExtensionModelUtils.getGroupAndParametersPairs(pmzd).map(groupAndParam -> component.getParameter(((ParameterGroupModel)groupAndParam.getFirst()).getName(), ((ParameterModel)groupAndParam.getSecond()).getName())).filter(param -> param != null && param.getValue().getRight() instanceof ComponentAst).map(param -> this.validate((ComponentAst)param.getValue().getRight(), artifact)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected List<ParameterGroupModel> resolveGroups(ParameterizedModel pmzd) {
        if (pmzd instanceof SourceModel) {
            return Stream.concat(Stream.concat(((SourceModel)pmzd).getSuccessCallback().map(scbk -> scbk.getParameterGroupModels().stream()).orElse(Stream.empty()), ((SourceModel)pmzd).getErrorCallback().map(scbk -> scbk.getParameterGroupModels().stream()).orElse(Stream.empty())), pmzd.getParameterGroupModels().stream()).collect(Collectors.toList());
        }
        return pmzd.getParameterGroupModels();
    }
}

