/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.util.ExceptionHandler;
import org.mule.runtime.core.privileged.exception.MessagingException;

@Deprecated(since="4.11", forRemoval=true)
public class ExceptionUtils {
    public static boolean containsType(Throwable throwable, Class<? extends Throwable> type) {
        return ExceptionUtils.indexOfType(throwable, type) > -1;
    }

    public static int indexOfType(Throwable throwable, Class<? extends Throwable> type) {
        return org.apache.commons.lang3.exception.ExceptionUtils.indexOfType((Throwable)throwable, type);
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static String getFullStackTraceWithoutMessages(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        for (String frame : org.apache.commons.lang3.exception.ExceptionUtils.getStackFrames((Throwable)throwable)) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static Optional<ConnectionException> extractConnectionException(Throwable throwable) {
        return ExceptionUtils.extractOfType(throwable, ConnectionException.class);
    }

    public static Optional<Throwable> extractCauseOfType(Throwable throwable, Class<? extends Throwable> throwableType) {
        return ExceptionUtils.extractOfType(throwable, throwableType).map(Throwable::getCause);
    }

    public static <T extends Throwable> Optional<T> extractOfType(Throwable throwable, Class<T> throwableType) {
        if (throwableType.isInstance(throwable)) {
            return Optional.of(throwable);
        }
        if (throwable == null) {
            return Optional.empty();
        }
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (cause == throwable) {
                return Optional.empty();
            }
            if (!throwableType.isInstance(cause)) continue;
            return Optional.of(cause);
        }
        return Optional.empty();
    }

    public static <T, E extends Exception> T tryExpecting(Class<E> expectedExceptionType, Callable<T> callable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return exceptionHandler.handle(e);
        }
    }

    public static <T, E extends Exception> void tryExpecting(Class<E> expectedExceptionType, Runnable runnable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            exceptionHandler.handle(e);
        }
    }

    public static boolean isUnknownMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("UNKNOWN");
    }

    public static Throwable getMessagingExceptionCause(Throwable exception) {
        Throwable cause = exception;
        while (cause instanceof MessagingException) {
            cause = cause.getCause();
        }
        return cause != null ? cause : exception;
    }

    public static Optional<ComponentIdentifier> getComponentIdentifier(Component obj) {
        return Optional.ofNullable(ExceptionUtils.getComponentIdentifierOf(obj));
    }

    public static ComponentIdentifier getComponentIdentifierOf(Component obj) {
        return obj.getIdentifier();
    }

    private ExceptionUtils() {
    }
}

