/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.mule.maven.client.api.VersionUtils;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginPatchesResolver;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleArtifactPatchingModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginPatchesResolver
implements PluginPatchesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginPatchesResolver.class);
    private static final String MULE_ARTIFACT_PATCHES_LOCATION = "lib/patches/mule-artifact-patches";
    private static final String PATCH_FILES_EXTENSION = "jar";

    @Override
    public List<URL> resolve(ArtifactCoordinates pluginArtifactCoordinates) {
        List<URL> patches = new ArrayList<URL>();
        String artifactId = pluginArtifactCoordinates.getGroupId() + ":" + pluginArtifactCoordinates.getArtifactId() + ":" + pluginArtifactCoordinates.getVersion();
        File muleArtifactPatchesFolder = new File(MuleFoldersUtil.getMuleHomeFolder(), MULE_ARTIFACT_PATCHES_LOCATION);
        try {
            if (muleArtifactPatchesFolder.exists()) {
                VersionUtils versionUtils = VersionUtils.discoverVersionUtils(this.getClass().getClassLoader());
                patches = Files.walk(muleArtifactPatchesFolder.toPath(), new FileVisitOption[0]).filter(patchFilePath -> FilenameUtils.getExtension((String)patchFilePath.toString()).endsWith(PATCH_FILES_EXTENSION)).map(patchFilePath -> {
                    block5: {
                        try {
                            boolean versionContained;
                            MuleArtifactPatchingModel muleArtifactPatchingModel = MuleArtifactPatchingModel.loadModel(patchFilePath.toFile());
                            ArtifactCoordinates patchedArtifactCoordinates = muleArtifactPatchingModel.getArtifactCoordinates();
                            if (!patchedArtifactCoordinates.getGroupId().equals(pluginArtifactCoordinates.getGroupId()) || !patchedArtifactCoordinates.getArtifactId().equals(pluginArtifactCoordinates.getArtifactId())) break block5;
                            if (!patchedArtifactCoordinates.getClassifier().map(ArtifactType.PLUGIN.getMavenArtifactClassifier()::equals).orElse(false).booleanValue()) break block5;
                            try {
                                versionContained = versionUtils.containsVersion(pluginArtifactCoordinates.getVersion(), muleArtifactPatchingModel.getAffectedVersions());
                            }
                            catch (IllegalArgumentException e) {
                                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(e.getMessage() + ", patches against this artifact will not be applied"), (Throwable)e);
                            }
                            if (versionContained) {
                                LOGGER.info("Patching artifact '{}' with patch file '{}'", (Object)artifactId, patchFilePath);
                                return patchFilePath.toFile().toURI().toURL();
                            }
                        }
                        catch (IOException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an error processing the patch in '%s' file", patchFilePath)), (Throwable)e);
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an error processing the patches in '%s'", muleArtifactPatchesFolder)), (Throwable)e);
        }
        return patches;
    }
}

