/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.sdk.api.annotation.Extension;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

class ClasspathBasedDslContext
implements DslResolvingContext {
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> extensionsByName = new HashMap();
    private final Map<String, ExtensionModel> resolvedModels = new HashMap<String, ExtensionModel>();
    private final LazyValue<TypeCatalog> typeCatalog = new LazyValue<Supplier<TypeCatalog>>(() -> TypeCatalog.getDefault(this.getExtensions()));

    ClasspathBasedDslContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.findExtensionsInClasspath();
    }

    @Override
    public Optional<ExtensionModel> getExtension(String name) {
        if (!this.resolvedModels.containsKey(name) && this.extensionsByName.containsKey(name)) {
            this.resolvedModels.put(name, MuleExtensionUtils.loadExtension(this.extensionsByName.get(name)));
        }
        return Optional.ofNullable(this.resolvedModels.get(name));
    }

    @Override
    public Optional<ExtensionModel> getExtensionForType(String typeId) {
        return this.getTypeCatalog().getDeclaringExtension(typeId).flatMap(this::getExtension);
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.resolvedModels.size() != this.extensionsByName.size() ? this.extensionsByName.values().stream().map(MuleExtensionUtils::loadExtension).collect(Collectors.toSet()) : new HashSet<ExtensionModel>(this.resolvedModels.values());
    }

    @Override
    public TypeCatalog getTypeCatalog() {
        return this.typeCatalog.get();
    }

    private void findExtensionsInClasspath() {
        Collection mulePluginsUrls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{this.classLoader}).stream().filter(url -> url.getPath().contains(ArtifactType.PLUGIN.getMavenArtifactClassifier())).collect(Collectors.toList());
        this.getExtensionTypes(mulePluginsUrls).forEach(type -> this.extensionsByName.put(MuleExtensionAnnotationParser.getExtensionInfo(type).getName(), (Class<?>)type));
    }

    private Set<Class<?>> getExtensionTypes(Collection<URL> urls) {
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
            LinkedHashSet classes = new LinkedHashSet(reflections.getTypesAnnotatedWith(org.mule.runtime.extension.api.annotation.Extension.class));
            classes.addAll(reflections.getTypesAnnotatedWith(Extension.class));
            return classes;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }
}

