/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionalConnectionHandler;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBindingDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionBindingDelegate.class);
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;

    public TransactionBindingDelegate(ExtensionModel extensionModel, ComponentModel componentModel) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
    }

    public <T extends TransactionalConnection> ConnectionHandler<T> getBoundResource(boolean lazyConnections, final ExtensionTransactionKey txKey, final ConnectionSupplier<ConnectionHandler<T>> connectionHandlerSupplier) throws ConnectionException, TransactionException {
        final Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
        if (currentTx == null) {
            return connectionHandlerSupplier.get();
        }
        if (currentTx.hasResource(txKey)) {
            return new TransactionalConnectionHandler((ExtensionTransactionalResource)currentTx.getResource(txKey));
        }
        if (lazyConnections) {
            return new ConnectionHandler<T>(){
                private final LazyValue<ConnectionHandler<T>> boundResource = new LazyValue<Supplier<ConnectionHandler>>(() -> {
                    try {
                        return TransactionBindingDelegate.this.bindResource(txKey, connectionHandlerSupplier, currentTx);
                    }
                    catch (ConnectionException e) {
                        throw new MuleRuntimeException(new TransactionException(I18nMessageFactory.createStaticMessage("Cannot establish connection for the transaction: " + e.getMessage()), (Throwable)e));
                    }
                    catch (TransactionException e) {
                        throw new MuleRuntimeException(e);
                    }
                });

                @Override
                public T getConnection() throws ConnectionException {
                    return (TransactionalConnection)this.boundResource.get().getConnection();
                }

                @Override
                public void release() {
                    this.boundResource.ifComputed(ConnectionHandler::release);
                }

                @Override
                public void invalidate() {
                    this.boundResource.ifComputed(ConnectionHandler::invalidate);
                }
            };
        }
        return this.bindResource(txKey, connectionHandlerSupplier, currentTx);
    }

    private <T extends TransactionalConnection> ConnectionHandler<T> bindResource(ExtensionTransactionKey txKey, ConnectionSupplier<ConnectionHandler<T>> connectionHandlerSupplier, Transaction currentTx) throws ConnectionException, TransactionException {
        ConnectionHandler connectionHandler = connectionHandlerSupplier.get();
        TransactionalConnection connection = Objects.requireNonNull((TransactionalConnection)connectionHandler.getConnection(), () -> String.format("connection from '%s' (%s '%s' of extension '%s') is null", connectionHandler, NameUtils.getComponentModelTypeName(this.componentModel), this.componentModel.getName(), this.extensionModel.getName()));
        ExtensionTransactionalResource txResource = this.createTransactionalResource(currentTx, connectionHandler, connection);
        boolean bound = false;
        try {
            if (currentTx.supports(txKey, txResource)) {
                currentTx.bindResource(txKey, txResource);
                bound = true;
                TransactionalConnectionHandler transactionalConnectionHandler = new TransactionalConnectionHandler(txResource);
                return transactionalConnectionHandler;
            }
            try {
                throw new TransactionException(I18nMessageFactory.createStaticMessage(String.format("%s '%s' of extension '%s' uses a transactional connection '%s', but the current transaction doesn't support it and could not be bound", NameUtils.getComponentModelTypeName(this.componentModel), this.componentModel.getName(), this.extensionModel.getName(), connection.getClass().getName())));
            }
            catch (Exception e) {
                if (ReconnectionUtils.extractConnectionException(e).isPresent()) {
                    connectionHandler.invalidate();
                }
                throw e;
            }
        }
        finally {
            if (!bound) {
                try {
                    connectionHandler.release();
                }
                catch (Exception e) {
                    String msg = "Ignored '" + e.getClass().getName() + ": " + e.getMessage() + "' during connection release";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn(msg, (Throwable)e);
                    }
                    LOGGER.warn(msg);
                }
            }
        }
    }

    private ExtensionTransactionalResource createTransactionalResource(Transaction currentTx, ConnectionHandler connectionHandler, Object connection) {
        return connection instanceof XATransactionalConnection ? new XAExtensionTransactionalResource<XATransactionalConnection>((XATransactionalConnection)connection, connectionHandler, currentTx) : new ExtensionTransactionalResource<TransactionalConnection>((TransactionalConnection)connection, connectionHandler, currentTx);
    }

    @FunctionalInterface
    public static interface ConnectionSupplier<T> {
        public T get() throws ConnectionException;
    }
}

