/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.api.processor;

import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractRaiseErrorProcessor;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.module.extension.mule.internal.error.ThrowableError;

@Experimental
public final class MuleSdkRaiseErrorProcessor
extends AbstractRaiseErrorProcessor {
    private static final DataType ERROR_DATA_TYPE = DataType.fromType(Error.class);
    private AttributeEvaluator causeEvaluator = new AttributeEvaluator("#[error]", ERROR_DATA_TYPE);

    @Override
    protected ComponentIdentifier calculateErrorIdentifier(String typeId) {
        return ComponentIdentifier.builder().namespace("THIS").name(typeId).build();
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.causeEvaluator.initialize(this.expressionManager);
    }

    @Override
    protected TypedException getException(ErrorType type, String message, CoreEvent event) {
        return new TypedException(this.calculateCause(event, message), type);
    }

    private Throwable calculateCause(CoreEvent event, String message) {
        Error causeError = (Error)this.causeEvaluator.resolveTypedValue(event).getValue();
        if (causeError == null) {
            return new DefaultMuleException(message);
        }
        return ThrowableError.wrap(causeError);
    }

    public void setCause(String cause) {
        this.causeEvaluator = new AttributeEvaluator(cause, ERROR_DATA_TYPE);
    }
}

