/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.event.EventUtils;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;

public final class StreamingUtils {
    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, EventContext eventContext, ComponentLocation originatingLocation) {
        if (cursorProviderFactory != null && cursorProviderFactory.accepts(value)) {
            return cursorProviderFactory.of(eventContext, value, originatingLocation);
        }
        return value;
    }

    public static CoreEvent consumeRepeatablePayload(CoreEvent event) throws IOException {
        TypedValue payload = event.getMessage().getPayload();
        if (payload.getValue() == null) {
            return event;
        }
        TypedValue replacedPayload = StreamingUtils.consumeRepeatableValue(payload);
        if (replacedPayload != payload) {
            event = CoreEvent.builder(event).message(Message.builder(event.getMessage()).payload(replacedPayload).build()).build();
        }
        return event;
    }

    public static <T> TypedValue<T> consumeRepeatableValue(TypedValue<T> typedValue) throws IOException {
        T originalPayload = typedValue.getValue();
        if (originalPayload == null) {
            return typedValue;
        }
        DataType originalDataType = typedValue.getDataType();
        TypedValue<Object> replacedPayload = typedValue;
        if (originalPayload instanceof CursorStreamProvider) {
            CursorStreamProvider cursorStreamProviderPayload = (CursorStreamProvider)originalPayload;
            ByteArrayCursorStreamProvider consumedPayload = new ByteArrayCursorStreamProvider(StreamingUtils.cursorToByteArray(cursorStreamProviderPayload));
            replacedPayload = new TypedValue<ByteArrayCursorStreamProvider>(consumedPayload, DataType.builder(originalDataType).type(consumedPayload.getClass()).build());
        } else if (originalPayload instanceof CursorIteratorProvider) {
            DataType newDataType;
            CursorIteratorProvider cursorIteratorProviderPayload = (CursorIteratorProvider)originalPayload;
            LinkedList consumed = new LinkedList();
            try (CursorIterator openCursor = (CursorIterator)cursorIteratorProviderPayload.openCursor();){
                openCursor.forEachRemaining(consumed::add);
            }
            if (originalDataType instanceof CollectionDataType) {
                CollectionDataType collectionDataType = (CollectionDataType)originalDataType;
                newDataType = DataType.builder(originalDataType).collectionType(consumed.getClass()).itemType(collectionDataType.getItemDataType().getType()).itemMediaType(collectionDataType.getItemDataType().getMediaType()).build();
            } else {
                newDataType = DataType.builder(originalDataType).type(consumed.getClass()).build();
            }
            replacedPayload = new TypedValue(consumed, newDataType);
        }
        return replacedPayload;
    }

    private static byte[] cursorToByteArray(CursorStreamProvider cursorStreamProvider) throws IOException {
        try (InputStream input = (InputStream)cursorStreamProvider.openCursor();){
            byte[] byArray = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
    }

    public static <T> TypedValue<T> updateTypedValueForStreaming(TypedValue<T> value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        return StreamingUtils.updateTypedValueForStreaming(value, EventUtils.getRoot(event.getContext()), streamingManager);
    }

    public static <T> TypedValue<T> updateTypedValueForStreaming(TypedValue<T> value, EventContext rootEventContext, StreamingManager streamingManager) {
        T payload = value.getValue();
        if (payload instanceof CursorProvider) {
            CursorProvider cursorProviderPayload = (CursorProvider)payload;
            CursorProvider cursorProvider = streamingManager.manage(cursorProviderPayload, rootEventContext);
            if (cursorProvider == payload) {
                return value;
            }
            DataType dataType = DataType.builder(value.getDataType()).type(cursorProvider.getClass()).build();
            return new TypedValue(cursorProvider, dataType, value.getByteLength());
        }
        return value;
    }

    public static Function<CoreEvent, CoreEvent> updateEventForStreaming(StreamingManager streamingManager) {
        return event -> {
            TypedValue payload = event.getMessage().getPayload();
            if (payload.getValue() instanceof CursorProvider) {
                TypedValue updatedPayload = StreamingUtils.updateTypedValueForStreaming(payload, event, streamingManager);
                if (updatedPayload == payload) {
                    return event;
                }
                Message message = Message.builder(event.getMessage()).payload(updatedPayload).build();
                return CoreEvent.builder(event).message(message).build();
            }
            return event;
        };
    }

    public static <T> TypedValue<T> updateTypedValueWithCursorProvider(TypedValue<T> value) {
        T payload = value.getValue();
        if (payload instanceof CursorStream) {
            CursorStream cursorStreamPayload = (CursorStream)payload;
            CursorProvider provider = cursorStreamPayload.getProvider();
            DataType dataType = DataType.builder(value.getDataType()).type(provider.getClass()).build();
            return new TypedValue<CursorProvider>(provider, dataType, value.getByteLength());
        }
        return value;
    }

    public static boolean supportsStreaming(ComponentModel componentModel) {
        ConnectableComponentModel connectableComponentModel;
        return componentModel instanceof ConnectableComponentModel && (connectableComponentModel = (ConnectableComponentModel)componentModel).supportsStreaming();
    }

    private StreamingUtils() {
    }
}

