/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.parameter.AbstractStereotypedModel;

public abstract class AbstractComponentModel
extends AbstractStereotypedModel
implements ComponentModel {
    private List<? extends NestableElementModel> nestedComponents;
    private Set<ErrorModel> errors;
    private Set<String> semanticTerms;
    private final ComponentVisibility visibility;

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, ComponentVisibility visibility, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, nestedComponents, displayModel, errors, stereotype, visibility, modelProperties, null);
    }

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, ComponentVisibility visibility, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, nestedComponents, displayModel, errors, stereotype, visibility, modelProperties, deprecationModel, null);
    }

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, ComponentVisibility visibility, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms) {
        this(name, description, parameterGroupModels, nestedComponents, displayModel, errors, stereotype, visibility, modelProperties, deprecationModel, semanticTerms, null);
    }

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, ComponentVisibility visibility, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms, MuleVersion minMuleVersion) {
        super(name, description, parameterGroupModels, displayModel, stereotype, modelProperties, deprecationModel, minMuleVersion);
        this.nestedComponents = this.copy(nestedComponents);
        this.errors = Collections.unmodifiableSet(new LinkedHashSet<ErrorModel>(errors));
        this.semanticTerms = semanticTerms != null ? Collections.unmodifiableSet(semanticTerms) : Collections.emptySet();
        this.visibility = visibility;
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        if (this.errors == null) {
            this.errors = Collections.emptySet();
        }
        return this.errors;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        if (this.nestedComponents == null) {
            this.nestedComponents = Collections.emptyList();
        }
        return this.nestedComponents;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return this.semanticTerms;
    }

    @Override
    public ComponentVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String toString() {
        return "AbstractComponentModel{nestedComponents=" + this.nestedComponents + ", errors=" + this.errors + ", semanticTerms=" + this.semanticTerms + ", visibility=" + (Object)((Object)this.visibility) + "} " + super.toString();
    }
}

