/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

final class FunctionModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private final Map<FunctionModelParser, FunctionDeclarer> functionDeclarers = new HashMap<FunctionModelParser, FunctionDeclarer>();

    FunctionModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, List<FunctionModelParser> parsers, ExtensionLoadingContext context) {
        for (FunctionModelParser parser : parsers) {
            if (parser.isIgnored()) continue;
            if (this.functionDeclarers.containsKey(parser)) {
                extensionDeclarer.withFunction(this.functionDeclarers.get(parser));
                continue;
            }
            FunctionDeclarer function = (FunctionDeclarer)extensionDeclarer.withFunction(parser.getName()).describedAs(parser.getDescription());
            parser.getDeprecationModel().ifPresent(function::withDeprecation);
            parser.getFunctionExecutorFactory().map(FunctionExecutorModelProperty::new).ifPresent(function::withModelProperty);
            parser.getOutputType().applyOn(function.withOutput());
            this.loader.getParameterModelsLoaderDelegate().declare(function, parser.getParameterGroupModelParsers(), extensionDeclarer, context);
            parser.getAdditionalModelProperties().forEach(function::withModelProperty);
            MinMuleVersionUtils.declareWithBaselineMmv(parser::getResolvedMinMuleVersion, function, ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getMinMuleVersion(), context);
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)function.getDeclaration(), parser);
            this.functionDeclarers.put(parser, function);
        }
    }
}

