/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public abstract class AbstractErrorValidation
implements Validation {
    protected static final String ON_ERROR = "on-error";
    protected static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    protected static final String ON_ERROR_CONTINUE = "on-error-continue";
    protected static final String RAISE_ERROR = "raise-error";
    protected static final ComponentIdentifier ON_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error").build();
    protected static final ComponentIdentifier ON_ERROR_PROPAGATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-propagate").build();
    protected static final ComponentIdentifier ON_ERROR_CONTINUE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-continue").build();
    protected static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();

    protected boolean isErrorTypePresentAndPropertyDependant(ComponentAst component) {
        ComponentParameterAst errorTypeParam = this.getErrorTypeParam(component);
        if (errorTypeParam == null) {
            return false;
        }
        String errorTypeString = errorTypeParam.getRawValue();
        return !StringUtils.isEmpty((CharSequence)errorTypeString) && MuleAstUtils.hasPropertyPlaceholder(errorTypeString);
    }

    protected ComponentParameterAst getErrorTypeParam(ComponentAst component) {
        return component.getParameter("General", "type");
    }

    protected boolean errorMappingPresent(ComponentAst operationComponent) {
        if (!operationComponent.getModel(ParameterizedModel.class).isPresent()) {
            return false;
        }
        ComponentParameterAst errorMappingsParam = AbstractErrorValidation.getErrorMappingsParameter(operationComponent);
        return errorMappingsParam != null && errorMappingsParam.getValue().getValue().isPresent();
    }

    protected boolean errorMappingSourceNotPropertyDependant(ComponentAst operationComponent) {
        return ((List)AbstractErrorValidation.getErrorMappingsParameter(operationComponent).getValue().getRight()).stream().noneMatch(errorMapping -> MuleAstUtils.hasPropertyPlaceholder(errorMapping.getSource()));
    }

    protected boolean errorMappingTargetNotPropertyDependant(ComponentAst operationComponent) {
        return ((List)AbstractErrorValidation.getErrorMappingsParameter(operationComponent).getValue().getRight()).stream().noneMatch(errorMapping -> MuleAstUtils.hasPropertyPlaceholder(errorMapping.getTarget()));
    }

    protected boolean errorMappingSourcePropertyDependant(ComponentAst operationComponent) {
        return ((List)AbstractErrorValidation.getErrorMappingsParameter(operationComponent).getValue().getRight()).stream().anyMatch(errorMapping -> MuleAstUtils.hasPropertyPlaceholder(errorMapping.getSource()));
    }

    protected boolean errorMappingTargetPropertyDependant(ComponentAst operationComponent) {
        return ((List)AbstractErrorValidation.getErrorMappingsParameter(operationComponent).getValue().getRight()).stream().anyMatch(errorMapping -> MuleAstUtils.hasPropertyPlaceholder(errorMapping.getTarget()));
    }

    protected static List<ErrorMapping> getErrorMappings(ComponentAst component) {
        return (List)AbstractErrorValidation.getErrorMappingsParameter(component).getValue().getRight();
    }

    protected static ComponentParameterAst getErrorMappingsParameter(ComponentAst component) {
        return component.getParameter("Error Mappings", "errorMappings");
    }
}

