/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverUtils;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.metadata.NullQueryMetadataResolver;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataTypeResolverUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class MetadataComponentModelValidator
implements ExtensionModelValidator {
    private static final String EMPTY_RESOLVER_NAME = "%s '%s' specifies a metadata resolver '%s' which has an empty %s name";

    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        Optional<ExtensionTypeDescriptorModelProperty> property = extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        if (property.isPresent() && !property.get().getType().getDeclaringClass().isPresent()) {
            return;
        }
        final HashMap names = new HashMap();
        new ExtensionWalker(){

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.validateComponent(model);
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.validateComponent(model);
            }

            private void validateComponent(ConnectableComponentModel model) {
                MetadataComponentModelValidator.this.validateMetadataReturnType(extensionModel, model, problemsReporter);
                MetadataResolverFactory resolverFactory = MuleExtensionUtils.getMetadataResolverFactory(model);
                MetadataComponentModelValidator.this.validateMetadataOutputAttributes(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateMetadataKeyId(extensionModel, model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateCategoriesInScope(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateResolversName(model, resolverFactory, names, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateResolversName(ComponentModel model, MetadataResolverFactory resolverFactory, Map<String, Map<String, Class<?>>> names, ProblemsReporter problemsReporter) {
        LinkedList<NamedTypeResolver> resolvers = new LinkedList<NamedTypeResolver>();
        resolvers.addAll(this.getAllInputResolvers(model, resolverFactory));
        resolvers.add(resolverFactory.getOutputResolver());
        resolvers.stream().filter(r -> !JavaMetadataTypeResolverUtils.isNullResolver(r.getClass())).forEach(r -> {
            if (StringUtils.isBlank((CharSequence)r.getResolverName())) {
                problemsReporter.addError(new Problem(model, String.format(EMPTY_RESOLVER_NAME, StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(model)), model.getName(), r.getClass().getSimpleName(), "resolver")));
                return;
            }
            if (StringUtils.isBlank((CharSequence)r.getCategoryName())) {
                problemsReporter.addError(new Problem(model, String.format(EMPTY_RESOLVER_NAME, StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(model)), model.getName(), r.getClass().getSimpleName(), "categoryName")));
                return;
            }
            Class existingClass = (Class)names.getOrDefault(r.getCategoryName(), Map.of()).get(r.getResolverName());
            if (existingClass != null && existingClass != JavaMetadataTypeResolverUtils.getEnclosingClass(r)) {
                problemsReporter.addError(new Problem(model, String.format("%s '%s' specifies metadata resolvers with repeated name '%s' for the same category '%s'. Resolver names should be unique for a given category. Affected resolvers are '%s' and '%s'", StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(model)), model.getName(), r.getResolverName(), r.getCategoryName(), existingClass.getSimpleName(), JavaMetadataTypeResolverUtils.getEnclosingClass(r).getSimpleName())));
            }
            names.computeIfAbsent(r.getCategoryName(), k -> new HashMap()).put(r.getResolverName(), JavaMetadataTypeResolverUtils.getEnclosingClass(r));
        });
    }

    private void validateMetadataKeyId(ExtensionModel extensionModel, final ComponentModel model, MetadataResolverFactory resolverFactory, final ProblemsReporter problemsReporter) {
        final String modelTypeName = StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(model));
        Optional<MetadataKeyIdModelProperty> keyId = model.getModelProperty(MetadataKeyIdModelProperty.class);
        if (keyId.isPresent()) {
            if (MuleExtensionUtils.isCompileTime(extensionModel) && resolverFactory.getOutputResolver() instanceof NullMetadataResolver && !this.thereIsAnInputTypeResolverDefined(this.getAllInputResolvers(model, resolverFactory))) {
                problemsReporter.addError(new Problem(model, String.format("%s '%s' defines a MetadataKeyId parameter but neither an Output nor Type resolver that makes use of it was defined", modelTypeName, model.getName())));
            }
            keyId.get().getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitObject(ObjectType objectType) {
                    List parts = model.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
                    List defaultParts = parts.stream().filter(p -> p.getDefaultValue() != null).collect(Collectors.toList());
                    if (!defaultParts.isEmpty() && defaultParts.size() != parts.size()) {
                        String typeName = ExtensionMetadataTypeUtils.getId(objectType).orElse("Anonymous type");
                        problemsReporter.addError(new Problem(model, String.format("%s '%s' uses the multilevel key of type '%s', which defines '%s' MetadataKeyPart with default values, but the type contains '%s' MetadataKeyParts. All the annotated MetadataKeyParts should have a default value if at least one part has a default value. Either add the missing defaults or remove all of them.", modelTypeName, model.getName(), typeName, defaultParts.size(), parts.size())));
                    }
                }
            });
        } else if (!(resolverFactory.getKeyResolver() instanceof NullMetadataResolver)) {
            problemsReporter.addError(new Problem(model, String.format("%s '%s' does not define a MetadataKeyId parameter but a TypeKeysResolver of type '%s' was associated to it.", modelTypeName, model.getName(), resolverFactory.getKeyResolver().getClass().getName())));
        }
    }

    private void validateMetadataOutputAttributes(ConnectableComponentModel component, MetadataResolverFactory resolverFactory, ProblemsReporter problemsReporter) {
        if (MetadataTypeUtils.isVoid(component.getOutputAttributes().getType()) && !(resolverFactory.getOutputAttributesResolver() instanceof NullMetadataResolver) && !MetadataTypeUtils.isCollection(component.getOutput().getType())) {
            problemsReporter.addError(new Problem(component, String.format("%s '%s' has an AttributesTypeResolver defined but it doesn't declare any attributes as part of its output.", StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(component)), component.getName())));
        }
    }

    private void validateMetadataReturnType(ExtensionModel extensionModel, ConnectableComponentModel component, ProblemsReporter problemsReporter) {
        if (!this.shouldValidateComponentOutputMetadata(component)) {
            return;
        }
        OutputTypeResolver<Object> outputResolver = MuleExtensionUtils.getMetadataResolverFactory(component).getOutputResolver();
        MetadataType modelOutputType = component.getOutput().getType();
        if (outputResolver instanceof NullMetadataResolver) {
            this.validateNoOutputResolverIsNeeded(extensionModel, component, problemsReporter, modelOutputType);
        } else if (MuleExtensionUtils.isCompileTime(extensionModel)) {
            this.validateVoidOperationsDontDeclareOutputResolver(component, problemsReporter, outputResolver, modelOutputType);
        }
    }

    private void validateNoOutputResolverIsNeeded(final ExtensionModel extensionModel, final ConnectableComponentModel component, final ProblemsReporter problemsReporter, MetadataType modelOutputType) {
        modelOutputType.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                if (!MetadataComponentModelValidator.this.isCustomStaticType(objectType)) {
                    objectType.getOpenRestriction().ifPresent(t -> MetadataComponentModelValidator.this.checkValidType(component, extensionModel, (MetadataType)t, problemsReporter));
                    MetadataComponentModelValidator.this.checkValidType(component, extensionModel, objectType, problemsReporter);
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                if (!MetadataComponentModelValidator.this.isCustomStaticType(arrayType)) {
                    arrayType.getType().accept(this);
                }
            }
        });
    }

    private void validateVoidOperationsDontDeclareOutputResolver(ConnectableComponentModel component, ProblemsReporter problemsReporter, OutputTypeResolver<Object> outputResolver, MetadataType modelOutputType) {
        if (modelOutputType instanceof VoidType) {
            problemsReporter.addError(new Problem(component, String.format("A Metadata OutputResolver named '%s' in category '%s' was defined for the Void Operation '%s'. Output resolvers cannot be used on Void Operations, since they produce no output.", outputResolver.getResolverName(), outputResolver.getCategoryName(), component.getName())));
        } else if (this.isCustomStaticType(modelOutputType)) {
            component.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(mp -> mp.getOperationElement().getOperationReturnMetadataType()).filter(t -> t instanceof VoidType).ifPresent(t -> problemsReporter.addError(new Problem(component, String.format("An Static Metadata OutputResolver was defined for the Void Operation '%s'. Output resolvers cannot be used on Void Operations, since they produce no output.", component.getName()))));
        }
    }

    private boolean isCustomStaticType(MetadataType metadataType) {
        return metadataType.getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent();
    }

    private void validateCategoriesInScope(ComponentModel componentModel, MetadataResolverFactory metadataResolverFactory, ProblemsReporter problemsReporter) {
        this.validateCategoryNames(componentModel, problemsReporter, MetadataResolverUtils.getAllResolvers(metadataResolverFactory));
    }

    private List<InputTypeResolver<Object>> getAllInputResolvers(ComponentModel componentModel, MetadataResolverFactory resolverFactory) {
        return componentModel.getAllParameterModels().stream().map(NamedObject::getName).map(resolverFactory::getInputResolver).collect(Collectors.toList());
    }

    private boolean thereIsAnInputTypeResolverDefined(List<InputTypeResolver<Object>> inputTypeResolverList) {
        return inputTypeResolverList.stream().anyMatch(typeResolver -> !(typeResolver instanceof NullMetadataResolver));
    }

    private void validateCategoryNames(ComponentModel componentModel, ProblemsReporter problemsReporter, List<NamedTypeResolver> resolvers) {
        resolvers.stream().filter(r -> StringUtils.isBlank((CharSequence)r.getCategoryName())).findFirst().ifPresent(r -> problemsReporter.addError(new Problem(componentModel, String.format(EMPTY_RESOLVER_NAME, StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(componentModel)), componentModel.getName(), r.getClass().getSimpleName(), "category"))));
        Set names = resolvers.stream().filter(r -> !JavaMetadataTypeResolverUtils.isNullResolver(r.getClass()) && !r.getClass().equals(NullQueryMetadataResolver.class)).map(NamedTypeResolver::getCategoryName).collect(Collectors.toSet());
        if (names.size() > 1) {
            Problem problem = new Problem(componentModel, String.format("%s '%s' specifies metadata resolvers that doesn't belong to the same category. The following categories were the ones found '%s'", StringUtils.capitalize((String)NameUtils.getComponentModelTypeName(componentModel)), componentModel.getName(), StringUtils.join(names, (String)",")));
            problemsReporter.addError(problem);
        }
    }

    private void checkValidType(ConnectableComponentModel componentModel, ExtensionModel extensionModel, MetadataType metadataType, ProblemsReporter problemsReporter) {
        String componentTypeName = NameUtils.getComponentModelTypeName(componentModel);
        ExtensionMetadataTypeUtils.getType(metadataType).ifPresent(type -> {
            String declarationMessageModifier = "";
            MetadataType modelType = componentModel.getOutput().getType();
            if (modelType instanceof ArrayType) {
                declarationMessageModifier = "a collection of ";
            } else if (modelType instanceof ObjectType && ((ObjectType)modelType).isOpen()) {
                declarationMessageModifier = "a map of ";
            }
            if (Object.class.equals(type)) {
                problemsReporter.addError(new Problem(extensionModel, String.format("%s '%s' declares %s'%s' as its return type. Components that return a type such as Object or Map (or a collection of any of those) must have defined an OutputResolver", StringUtils.capitalize((String)componentTypeName), componentModel.getName(), declarationMessageModifier, type)));
            } else if (this.isInvalidInterface(metadataType, (Class<?>)type)) {
                problemsReporter.addError(new Problem(extensionModel, String.format("%s '%s' declares %s'%s' as its return type. Components that return an interface (or a collection of interfaces) must have defined an OutputResolver", StringUtils.capitalize((String)componentTypeName), componentModel.getName(), declarationMessageModifier, type)));
            }
        });
    }

    private boolean isInvalidInterface(MetadataType metadataType, Class<?> type) {
        return type.isInterface() && metadataType instanceof ObjectType && !ExtensionMetadataTypeUtils.isMap(metadataType) && !type.equals(Message.class) && ExtensionMetadataTypeUtils.getType(metadataType).map(t -> Serializable.class.equals(t)).orElse(false) == false;
    }

    private boolean shouldValidateComponentOutputMetadata(ConnectableComponentModel model) {
        return model.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(mp -> mp.getOperationElement()).map(m -> !JavaModelLoaderUtils.isScope(m) && !JavaModelLoaderUtils.isRouter(m)).orElse(true);
    }
}

