/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.GroupValueSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.util.SingleValueSetter;
import org.mule.runtime.module.extension.internal.util.ValueSetter;

public abstract class ResolverSetBasedObjectBuilder<T>
implements ObjectBuilder<T>,
Initialisable {
    protected final ResolverSet resolverSet;
    protected List<ValueSetter> singleValueSetters;
    private final List<ValueSetter> groupValueSetters;
    private final ConcurrentMap<Class<?>, Optional<FieldSetter>> encodingFieldSetter = new ConcurrentHashMap();
    private final Injector injector;
    private ReflectionCache reflectionCache;
    protected final ExpressionManager expressionManager;
    protected final ArtifactEncoding artifactEncoding;

    public ResolverSetBasedObjectBuilder(Class<?> prototypeClass, ResolverSet resolverSet, ExpressionManager expressionManager, ArtifactEncoding artifactEncoding, Injector injector) {
        this(prototypeClass, null, resolverSet, expressionManager, artifactEncoding, injector);
    }

    public ResolverSetBasedObjectBuilder(Class<?> prototypeClass, ParameterizedModel model, ResolverSet resolverSet, ExpressionManager expressionManager, ArtifactEncoding artifactEncoding, Injector injector) {
        this.resolverSet = resolverSet;
        this.injector = injector;
        this.expressionManager = expressionManager;
        this.artifactEncoding = artifactEncoding;
        this.singleValueSetters = this.createSingleValueSetters(prototypeClass, resolverSet);
        this.groupValueSetters = model != null ? GroupValueSetter.settersFor(model, () -> this.getReflectionCache(), () -> expressionManager) : Collections.emptyList();
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        return this.build(this.resolverSet.resolve(context));
    }

    public T build(ResolverSetResult result) throws MuleException {
        T object = this.instantiateObject();
        this.populate(result, object);
        return object;
    }

    protected void populate(ResolverSetResult result, Object object) throws MuleException {
        this.setValues(object, result, this.groupValueSetters);
        this.setValues(object, result, this.singleValueSetters);
        this.encodingFieldSetter.computeIfAbsent(object.getClass(), clazz -> IntrospectionUtils.getDefaultEncodingFieldSetter(object, this.getReflectionCache())).ifPresent(s -> s.set(object, this.artifactEncoding.getDefaultEncoding().name()));
    }

    protected List<ValueSetter> createSingleValueSetters(Class<?> prototypeClass, ResolverSet resolverSet) {
        return resolverSet.getResolvers().keySet().stream().map(parameterName -> IntrospectionUtils.getField(prototypeClass, parameterName, this.getReflectionCache()).map(f -> new SingleValueSetter((String)parameterName, (Field)f))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toImmutableList());
    }

    private void setValues(Object target, ResolverSetResult result, List<ValueSetter> setters) throws MuleException {
        for (ValueSetter setter : setters) {
            setter.set(target, result);
        }
    }

    protected abstract T instantiateObject();

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, this.injector);
    }

    public ReflectionCache getReflectionCache() {
        if (this.reflectionCache == null) {
            this.reflectionCache = new ReflectionCache();
        }
        return this.reflectionCache;
    }
}

