/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.domain.AmbiguousDomainReferenceException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;

public class DefaultDomainManager
implements DomainRepository,
DomainManager {
    private Map<String, Domain> domainsByName = new HashMap<String, Domain>();

    @Override
    public void addDomain(Domain domain) {
        String domainName = DefaultDomainManager.getDomainName(domain);
        if (this.domainsByName.containsKey(domainName)) {
            throw new IllegalArgumentException(String.format("Domain '%s' already exists", domainName));
        }
        this.domainsByName.put(domainName, domain);
    }

    @Override
    public void removeDomain(Domain domain) {
        String domainName = DefaultDomainManager.getDomainName(domain);
        this.domainsByName.remove(domainName);
    }

    @Override
    public Domain getDomain(String domainName) throws DomainNotFoundException {
        Domain domain = this.domainsByName.get(domainName);
        if (domain == null) {
            throw new DomainNotFoundException(domainName, this.domainsByName.keySet());
        }
        return domain;
    }

    @Override
    public boolean contains(String name) {
        return this.domainsByName.containsKey(name);
    }

    @Override
    public Domain getCompatibleDomain(BundleDescriptor wantedDescriptor) throws DomainNotFoundException, AmbiguousDomainReferenceException {
        HashSet<String> foundDomainNames = new HashSet<String>();
        Domain lastFoundDomain = null;
        for (Domain domain : this.domainsByName.values()) {
            BundleDescriptor currentDescriptor = ((DomainDescriptor)domain.getDescriptor()).getBundleDescriptor();
            if (currentDescriptor == null || !DefaultDomainManager.isCompatibleBundle(currentDescriptor, wantedDescriptor)) continue;
            foundDomainNames.add(((DomainDescriptor)domain.getDescriptor()).getName());
            lastFoundDomain = domain;
        }
        if (foundDomainNames.size() < 1) {
            throw new DomainNotFoundException(wantedDescriptor.getArtifactFileName(), this.domainsByName.keySet());
        }
        if (foundDomainNames.size() > 1) {
            throw new AmbiguousDomainReferenceException(wantedDescriptor, foundDomainNames);
        }
        return lastFoundDomain;
    }

    @Override
    public boolean containsCompatible(BundleDescriptor descriptor) {
        for (Domain domain : this.domainsByName.values()) {
            if (!DefaultDomainManager.isCompatibleBundle(((DomainDescriptor)domain.getDescriptor()).getBundleDescriptor(), descriptor)) continue;
            return true;
        }
        return false;
    }

    private static String getDomainName(Domain domain) {
        return ((DomainDescriptor)domain.getDescriptor()).getName();
    }

    public static boolean isCompatibleBundle(BundleDescriptor available, BundleDescriptor expected) {
        if (!available.getClassifier().equals(expected.getClassifier())) {
            return false;
        }
        if (!available.getGroupId().equals(expected.getGroupId())) {
            return false;
        }
        if (!available.getArtifactId().equals(expected.getArtifactId())) {
            return false;
        }
        return BundleDescriptorUtils.isCompatibleVersion(available.getVersion(), expected.getVersion());
    }
}

