/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullSafeValueResolverWrapper<T>
implements ValueResolver<T>,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NullSafeValueResolverWrapper.class);
    private final ValueResolver<T> delegate;
    private final ValueResolver<T> fallback;
    private final Injector injector;

    public static <T> ValueResolver<T> of(final ValueResolver<T> delegate, MetadataType type, final ReflectionCache reflectionCache, final ExtendedExpressionManager expressionManager, final ArtifactEncoding artifactEncoding, final Injector injector, final TransformationService transformationService, final ObjectTypeParametersResolver parametersResolver) {
        Objects.requireNonNull(delegate, "delegate cannot be null");
        final Reference wrappedResolver = new Reference();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                Class clazz = JavaTypeUtils.getType(objectType);
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, MapValueResolver.of(clazz, Collections.emptyList(), Collections.emptyList(), injector), injector));
                    return;
                }
                String requiredFields = objectType.getFields().stream().filter(f -> f.isRequired() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup(f)).map(MetadataTypeUtils::getLocalPart).collect(Collectors.joining(", "));
                if (!StringUtils.isBlank((CharSequence)requiredFields)) {
                    LOGGER.debug("Class '{}' cannot be used with NullSafe Wrapper since it contains non optional fields: [{}]", (Object)clazz.getName(), (Object)requiredFields);
                    wrappedResolver.set(delegate);
                    return;
                }
                ResolverSet resolverSet = new ResolverSet(injector);
                for (Field field : IntrospectionUtils.getFields(clazz)) {
                    ValueResolver<Object> fieldResolver = null;
                    ObjectFieldType objectField = objectType.getFieldByName(IntrospectionUtils.getAlias(field)).orElse(null);
                    if (objectField == null) continue;
                    Optional<String> defaultValue = MetadataTypeUtils.getDefaultValue(objectField);
                    if (defaultValue.isPresent()) {
                        fieldResolver = ResolverUtils.getFieldDefaultValueValueResolver(objectField, injector, expressionManager, transformationService);
                    } else if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup(objectField)) {
                        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(JavaTypeUtils.getType(objectField.getValue()), reflectionCache);
                        resolverSet.add(field.getName(), new ObjectBuilderValueResolver(groupBuilder, injector));
                        ObjectType childGroup = (ObjectType)objectField.getValue();
                        parametersResolver.resolveParameters(childGroup, groupBuilder);
                        parametersResolver.resolveParameterGroups(childGroup, groupBuilder);
                    } else {
                        Optional<Class<?>> defaultImplementingType = IntrospectionUtils.getNullSafeDefaultImplementedType(field);
                        if (defaultImplementingType.isPresent()) {
                            Class<?> nullSafeClass = defaultImplementingType.get();
                            MetadataType nullSafeType = Object.class.equals(nullSafeClass) ? objectField.getValue() : new BaseTypeBuilder(MetadataFormat.JAVA).objectType().id(nullSafeClass.getName()).with(new ClassInformationAnnotation(nullSafeClass)).build();
                            fieldResolver = NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), nullSafeType, reflectionCache, expressionManager, artifactEncoding, injector, transformationService, parametersResolver);
                        }
                        if (IntrospectionUtils.isConfigOverride(field)) {
                            StaticValueResolver<Object> fieldDelegate = fieldResolver != null ? fieldResolver : new StaticValueResolver<Object>(null);
                            fieldResolver = ConfigOverrideValueResolverWrapper.of(fieldDelegate, field.getName(), field.getType(), reflectionCache, injector, clazz.getName());
                        }
                    }
                    if (fieldResolver == null) continue;
                    resolverSet.add(field.getName(), fieldResolver);
                }
                DefaultResolverSetBasedObjectBuilder objectBuilder = new DefaultResolverSetBasedObjectBuilder(clazz, resolverSet, (ExpressionManager)expressionManager, artifactEncoding, injector);
                wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, new ObjectBuilderValueResolver(objectBuilder, injector), injector));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                Class collectionClass = JavaTypeUtils.getType(arrayType);
                wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, CollectionValueResolver.of(collectionClass, Collections.emptyList()), injector));
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                LOGGER.debug("Class '{}' cannot be used with NullSafe Wrapper since it is of a simple type", (Object)JavaTypeUtils.getType(metadataType).getName());
                wrappedResolver.set(delegate);
            }
        });
        return (ValueResolver)wrappedResolver.get();
    }

    private NullSafeValueResolverWrapper(ValueResolver<T> delegate, ValueResolver<T> fallback, Injector injector) {
        this.delegate = delegate;
        this.fallback = fallback;
        this.injector = injector;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        T value = this.delegate.resolve(context);
        return value == null ? this.fallback.resolve(context) : value;
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic() || this.fallback.isDynamic();
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.injector);
        LifecycleUtils.initialiseIfNeeded(this.fallback, this.injector);
    }
}

