/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.ValueResolverNotFoundException;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ResolverBasedComponentParameterization<M extends ParameterizedModel>
implements ComponentParameterization<M> {
    private final M model;
    private final ParameterValueResolver resolver;

    public ResolverBasedComponentParameterization(M model, ParameterValueResolver resolver) {
        this.model = model;
        this.resolver = resolver;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public Object getParameter(String parameterGroupName, String parameterName) {
        try {
            return this.getParameterValue(parameterName);
        }
        catch (ValueResolvingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getParameter(ParameterGroupModel parameterGroupModel, ParameterModel parameterModel) {
        try {
            return this.getParameterValue(parameterModel);
        }
        catch (ValueResolvingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<Pair<ParameterGroupModel, ParameterModel>, Object> getParameters() {
        HashMap<Pair<ParameterGroupModel, ParameterModel>, Object> parameterValues = new HashMap<Pair<ParameterGroupModel, ParameterModel>, Object>();
        this.forEachParameter((pgm, pm, value) -> parameterValues.put(new Pair<ParameterGroupModel, ParameterModel>(pgm, pm), value));
        return parameterValues;
    }

    @Override
    public void forEachParameter(ComponentParameterization.ParameterAction parameterAction) {
        for (ParameterGroupModel pgm : this.model.getParameterGroupModels()) {
            for (ParameterModel pm : pgm.getParameterModels()) {
                try {
                    Object value = this.getParameterValue(pm);
                    if (value == null) continue;
                    parameterAction.accept(pgm, pm, value);
                }
                catch (ValueResolvingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public Optional<ComponentIdentifier> getComponentIdentifier() {
        return Optional.empty();
    }

    private Object getParameterValue(ParameterModel parameterModel) throws ValueResolvingException {
        String memberName = IntrospectionUtils.getMemberName(parameterModel);
        try {
            return this.resolver.getParameterValue(memberName);
        }
        catch (ValueResolverNotFoundException e) {
            return null;
        }
    }

    private Object getParameterValue(String parameterName) throws ValueResolvingException {
        return this.getParameterValue(this.model.getAllParameterModels().stream().filter(pm -> pm.getName().equals(parameterName)).findFirst().orElseThrow(() -> new ValueResolvingException("Parameter with name `" + parameterName + "` not found in model")));
    }
}

