/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.alg.TransitiveReduction;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsDependenciesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginsDependenciesProcessor.class);

    public static <T> List<T> process(Collection<ArtifactPluginDescriptor> artifactPlugins, boolean parallelize, BiConsumer<List<T>, ArtifactPluginDescriptor> processor) {
        List processedDependencies = Collections.synchronizedList(new ArrayList());
        SimpleDirectedGraph depsGraph = new SimpleDirectedGraph(DefaultEdge.class);
        artifactPlugins.stream().forEach(apd -> depsGraph.addVertex((Object)apd.getBundleDescriptor()));
        artifactPlugins.stream().forEach(apd -> apd.getClassLoaderConfiguration().getDependencies().stream().filter(dep -> dep.getDescriptor().getClassifier().map(ArtifactType.PLUGIN.getMavenArtifactClassifier()::equals).orElse(false) != false && depsGraph.containsVertex((Object)dep.getDescriptor())).forEach(dep -> depsGraph.addEdge((Object)apd.getBundleDescriptor(), (Object)dep.getDescriptor(), (Object)new DefaultEdge())));
        TransitiveReduction.INSTANCE.reduce((Graph)depsGraph);
        LOGGER.debug("Dependencies graph: {}", (Object)depsGraph);
        while (!depsGraph.vertexSet().isEmpty()) {
            Set seenDependencies = Collections.synchronizedSet(new HashSet());
            PluginsDependenciesProcessor.artifactPluginsStream(artifactPlugins, parallelize).filter(artifactPlugin -> depsGraph.vertexSet().contains(artifactPlugin.getBundleDescriptor()) && depsGraph.outDegreeOf((Object)artifactPlugin.getBundleDescriptor()) == 0).forEach(artifactPlugin -> {
                LOGGER.debug("process({}): {}", (Object)(parallelize ? "parallel" : ""), artifactPlugin);
                seenDependencies.add(artifactPlugin.getBundleDescriptor());
                processor.accept(processedDependencies, (ArtifactPluginDescriptor)artifactPlugin);
            });
            seenDependencies.forEach(arg_0 -> ((SimpleDirectedGraph)depsGraph).removeVertex(arg_0));
            LOGGER.debug("process({}): next iteration on the depsGraph...", (Object)(parallelize ? "parallel" : ""));
        }
        return processedDependencies;
    }

    private static Stream<ArtifactPluginDescriptor> artifactPluginsStream(Collection<ArtifactPluginDescriptor> artifactPlugins, boolean parallelize) {
        return parallelize ? artifactPlugins.parallelStream() : artifactPlugins.stream();
    }
}

