/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class NameIsNotRepeated
implements Validation {
    private static final String MULE_ROOT_ELEMENT = "mule";
    public static final String TEST_NAMESPACE = "test";
    private static Set<ComponentIdentifier> ignoredNameValidationComponentList = Set.of(ComponentIdentifier.builder().namespace("mule").name("alias").build(), ComponentIdentifier.builder().namespace("mule").name("password-encryption-strategy").build(), ComponentIdentifier.builder().namespace("mule").name("custom-security-provider").build(), ComponentIdentifier.builder().namespace("mule").name("custom-encryption-strategy").build(), ComponentIdentifier.builder().namespace("mule").name("secret-key-encryption-strategy").build(), ComponentIdentifier.builder().namespace("mule").name("import").build(), ComponentIdentifier.builder().namespace("mule").name("security-manager").build(), ComponentIdentifier.builder().namespace("test").name("queue").build(), ComponentIdentifier.builder().namespace("test").name("invocation-counter").build());

    @Override
    public String getName() {
        return "Names are not repeated";
    }

    @Override
    public String getDescription() {
        return "'name' attribute in top-level elements are unique.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getComponentId().isPresent())).and(ComponentAstPredicatesFactory.currentElemement(component -> !ignoredNameValidationComponentList.contains(component.getIdentifier()))).and(ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(HasStereotypeModel.class).map(sm -> sm.getStereotype().isAssignableTo(MuleStereotypes.APP_CONFIG)).orElse(false) == false));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        List repeated = artifact.topLevelComponentsStream().filter(comp -> !comp.equals(component)).filter(ComponentAstPredicatesFactory.equalsComponentId(component.getComponentId().get())).collect(Collectors.toList());
        if (repeated.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<ComponentAst> allRepeated = new ArrayList<ComponentAst>();
        allRepeated.add(component);
        allRepeated.addAll(repeated);
        return Optional.of(ValidationResultItem.create(allRepeated, (Validation)this, "Two (or more) configuration elements have been defined with the same global name. Global name '" + component.getComponentId().get() + "' must be unique."));
    }
}

