/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.ApiKitStatsUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.construct.BackPressureStrategySelector;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.execution.FlowProcessor;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.interception.ReactiveInterceptor;
import org.mule.runtime.core.internal.management.stats.DefaultFlowsSummaryStatistics;
import org.mule.runtime.core.internal.management.stats.FlowClassifier;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.processor.interceptor.FlowInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    private final InterceptorManager interceptorManager;
    private final NotificationDispatcher notificationFirer;
    private final SchedulerService schedulerService;
    private final MessageSource source;
    private final List<Processor> processors;
    private MessageProcessorChain pipeline;
    private Consumer<Exception> errorRouterForSourceResponseError;
    private final ProcessingStrategyFactory processingStrategyFactory;
    private final ProcessingStrategy processingStrategy;
    private final List<ReactiveInterceptor> flowInterceptors = new LinkedList<ReactiveInterceptor>();
    private volatile boolean canProcessMessage = false;
    private Sink sink;
    private Scheduler completionCallbackScheduler;
    private Map<BackPressureReason, FlowBackPressureException> backPressureExceptions;
    private final int maxConcurrency;
    private final DefaultFlowsSummaryStatistics flowsSummaryStatistics;
    private final DefaultFlowsSummaryStatistics flowsSummaryStatisticsV2;
    private final boolean triggerFlow;
    private final boolean apikitFlow;
    private final FlowClassifier.FlowType flowType;
    private final ComponentInitialStateManager componentInitialStateManager;
    private final BackPressureStrategySelector backpressureStrategySelector;
    private final ErrorType FLOW_BACKPRESSURE_ERROR_TYPE;
    private AlertingSupport alertingSupport;
    private ComponentTracerFactory componentTracerFactory;

    public AbstractPipeline(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, Integer maxConcurrency, DefaultFlowsSummaryStatistics flowsSummaryStatistics, DefaultFlowsSummaryStatistics flowsSummaryStatisticsV2, FlowConstructStatistics flowConstructStatistics, ComponentInitialStateManager componentInitialStateManager) {
        super(name, muleContext, exceptionListener, initialState, flowConstructStatistics);
        FeatureFlaggingService featureFlaggingService;
        InternalProfilingService profilingService;
        FlowClassifier flowClassifier;
        try {
            this.interceptorManager = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(InterceptorManager.class);
            this.notificationFirer = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
            this.componentTracerFactory = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(ComponentTracerFactory.class);
            this.alertingSupport = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(AlertingSupport.class);
            flowClassifier = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(FlowClassifier.class);
            profilingService = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(InternalProfilingService.class);
            featureFlaggingService = (FeatureFlaggingService)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("core.featureFlaggingService");
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
        this.schedulerService = muleContext.getSchedulerService();
        this.source = source;
        this.componentInitialStateManager = componentInitialStateManager;
        this.processors = Collections.unmodifiableList(processors);
        this.maxConcurrency = maxConcurrency != null ? maxConcurrency : AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY;
        this.flowsSummaryStatistics = flowsSummaryStatistics;
        this.flowsSummaryStatisticsV2 = flowsSummaryStatisticsV2;
        this.triggerFlow = source != null;
        this.apikitFlow = ApiKitStatsUtils.isApiKitFlow(this.getName());
        this.flowType = flowClassifier != null ? flowClassifier.getFlowType(this.getName()) : FlowClassifier.FlowType.GENERIC;
        ProcessingStrategyFactory processingStrategyFactory2 = this.processingStrategyFactory = processingStrategyFactory.orElseGet(this::defaultProcessingStrategy);
        if (processingStrategyFactory2 instanceof AsyncProcessingStrategyFactory) {
            AsyncProcessingStrategyFactory asyncProcessingStrategyFactory = (AsyncProcessingStrategyFactory)processingStrategyFactory2;
            asyncProcessingStrategyFactory.setMaxConcurrency(this.maxConcurrency);
        } else if (maxConcurrency != null) {
            LOGGER.warn("{} does not support 'maxConcurrency'. Ignoring the value.", (Object)this.processingStrategyFactory.getClass().getSimpleName());
        }
        this.processingStrategy = this.processingStrategyFactory.create(profilingService, featureFlaggingService, this.schedulerService, muleContext::getSchedulerBaseConfig, this.getName(), muleContext.getConfiguration().getId(), ArtifactType.valueOf(muleContext.getArtifactType().name()), () -> muleContext.getConfiguration().getShutdownTimeout());
        this.backpressureStrategySelector = new BackPressureStrategySelector(this);
        this.FLOW_BACKPRESSURE_ERROR_TYPE = muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).orElseThrow();
    }

    protected MessageProcessorChain createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("flow @ " + this.getName());
        if (this.processingStrategy != null) {
            builder.setProcessingStrategy(this.processingStrategy);
        }
        this.configureMessageProcessors(builder);
        builder.setMessagingExceptionHandler(this.getExceptionListener());
        builder.setPipelineLocation(this.getLocation());
        builder.setComponentTracer(this.componentTracerFactory.fromComponent(this));
        return builder.build();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        return MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext.getConfiguration(), this::createDefaultProcessingStrategyFactory);
    }

    @Override
    public List<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public MessageSource getSource() {
        return this.source;
    }

    protected MessageProcessorChain getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isSynchronous() {
        return this.processingStrategy.isSynchronous();
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        this.backPressureExceptions = Collections.unmodifiableMap(Arrays.stream(BackPressureReason.values()).collect(Collectors.toMap(Function.identity(), backPressureReason -> FlowBackPressureException.createFlowBackPressureException(this, backPressureReason))));
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.source != null) {
            this.source.setListener(new Processor(){

                @Override
                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply(event, this);
                }

                @Override
                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Flux.from(publisher).transform((Function)AbstractPipeline.this.dispatchToFlow());
                }
            });
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.source, this.muleContext.getInjector());
        LifecycleUtils.initialiseIfNeeded((Object)this.pipeline, this.muleContext.getInjector());
        this.completionCallbackScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(this.getName() + ".flux.completionCallback"));
        this.flowInterceptors.addAll(ReactiveInterceptorAdapter.createInterceptors(this.interceptorManager.getFlowInterceptorFactories().stream().map(FlowInterceptorFactoryAdapter::new).toList(), this.muleContext.getInjector()));
        this.doInitialiseProcessingStrategy();
        this.updateFlowsSummaryStatistics(t -> t.incrementDeclaredTriggerFlow(this.getName()), t -> t.incrementDeclaredApikitFlow(this.getName()), t -> t.incrementDeclaredPrivateFlow(this.getName()));
    }

    @Override
    protected void doInitialiseProcessingStrategy() throws MuleException {
        LOGGER.debug("Initialising processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        super.doInitialiseProcessingStrategy();
        LifecycleUtils.initialiseIfNeeded(this.processingStrategy);
    }

    public Consumer<Exception> errorRouterForSourceResponseError(Function<Pipeline, Consumer<Exception>> terminationCallbackFactory) {
        if (this.errorRouterForSourceResponseError == null) {
            return this.doErrorRouterForSourceResponseError(terminationCallbackFactory);
        }
        return this.errorRouterForSourceResponseError;
    }

    private synchronized Consumer<Exception> doErrorRouterForSourceResponseError(Function<Pipeline, Consumer<Exception>> terminationCallbackFactory) {
        if (this.errorRouterForSourceResponseError == null) {
            Consumer<Exception> terminationCallback = terminationCallbackFactory.apply(this);
            this.errorRouterForSourceResponseError = this.getExceptionListener().router(Function.identity(), event -> terminationCallback.accept((MessagingException)event.getError().get().getCause()), error -> terminationCallback.accept((MessagingException)error));
        }
        return this.errorRouterForSourceResponseError;
    }

    protected final ReactiveProcessor dispatchToFlow() {
        return publisher -> Flux.from((Publisher)publisher).doOnNext(this.assertStarted()).transform(this.routeThroughProcessingStrategyTransformer()).transformDeferred(this.clearSubscribersErrorStrategy());
    }

    private Function<Flux<CoreEvent>, Publisher<CoreEvent>> clearSubscribersErrorStrategy() {
        return pub -> pub.contextWrite(context -> {
            Optional onErrorStrategy = context.getOrEmpty((Object)"reactor.onNextError.localStrategy");
            if (onErrorStrategy.isPresent() && onErrorStrategy.get().toString().contains("reactor.core.publisher.OnNextFailureStrategy$ResumeStrategy")) {
                BiFunction<Throwable, Object, Throwable> onErrorContinue = (e, o) -> null;
                return context.put((Object)"reactor.onNextError.localStrategy", onErrorContinue);
            }
            return context;
        });
    }

    protected Function<Publisher<CoreEvent>, Publisher<CoreEvent>> routeThroughProcessingStrategyTransformer() {
        FluxSinkRecorder pipelineOutlet = new FluxSinkRecorder();
        return eventPublisher -> Flux.from((Publisher)eventPublisher).transformDeferredContextual((pipelineUpstream, reactorContext) -> {
            if (((Boolean)reactorContext.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
                return this.handlePipelineError((Flux<Either<Throwable, CoreEvent>>)Flux.from(RxUtils.propagateCompletion(pipelineUpstream, pipelineOutlet.flux(), pipelineInlet -> this.splicePipeline(pipelineOutlet, (Publisher<CoreEvent>)pipelineInlet, true), pipelineOutlet::complete, pipelineOutlet::error)));
            }
            return this.handlePipelineError((Flux<Either<Throwable, CoreEvent>>)Flux.from(RxUtils.propagateCompletion(pipelineUpstream, pipelineOutlet.flux(), pipelineInlet -> this.splicePipeline(pipelineOutlet, (Publisher<CoreEvent>)pipelineInlet, false), pipelineOutlet::complete, pipelineOutlet::error, this.muleContext.getConfiguration().getShutdownTimeout(), this.completionCallbackScheduler, this.getDslSource())));
        });
    }

    private Flux<Either<Throwable, CoreEvent>> splicePipeline(FluxSinkRecorder<Either<Throwable, CoreEvent>> sinkRecorder, Publisher<CoreEvent> innerEventPub, boolean isWithinProcessToApply) {
        return Flux.from(innerEventPub).doOnNext(event -> ((BaseEventContext)event.getContext()).onResponse((e, t) -> {
            if (t != null) {
                sinkRecorder.next(Either.left(t, CoreEvent.class));
            } else if (e != null) {
                sinkRecorder.next(Either.right(Throwable.class, e));
            }
            if (isWithinProcessToApply) {
                sinkRecorder.complete();
            }
        })).doOnNext(this.getSource() == null || this.getSource().getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT ? event -> this.sink.accept((CoreEvent)event) : this::sinkEmit).map(e -> Either.empty());
    }

    private Flux<CoreEvent> handlePipelineError(Flux<Either<Throwable, CoreEvent>> flux) {
        return flux.map(result -> {
            result.applyLeft(t -> {
                throw Exceptions.propagate((Throwable)t);
            });
            return (CoreEvent)result.getRight();
        });
    }

    private void sinkEmit(CoreEvent event) {
        BackPressureReason emitFailReason = this.sink.emit(event);
        if (emitFailReason != null) {
            this.alertingSupport.triggerAlert("BACKPRESSURE_TRIGGERED", emitFailReason.name() + " - " + this.getName());
            this.notifyBackpressureException(event, this.backPressureExceptions.get((Object)emitFailReason));
        }
    }

    private void notifyBackpressureException(CoreEvent event, FlowBackPressureException wrappedException) {
        CoreEvent errorEvent = CoreEvent.builder(event).error(ErrorBuilder.builder(wrappedException).errorType(this.FLOW_BACKPRESSURE_ERROR_TYPE).build()).build();
        ((BaseEventContext)event.getContext()).error(new MessagingException(errorEvent, (Throwable)wrappedException, (Component)this));
    }

    private ReactiveProcessor processFlowFunction() {
        ReactiveProcessor interceptedPipeline;
        if (this.flowInterceptors.isEmpty()) {
            interceptedPipeline = this.pipeline;
        } else {
            FlowProcessor flowProcessor;
            ReactiveProcessor interceptorWrapperProcessorFunction = flowProcessor = new FlowProcessor(this.pipeline, this);
            for (ReactiveInterceptor interceptor : this.flowInterceptors) {
                interceptorWrapperProcessorFunction = (ReactiveProcessor)interceptor.apply(flowProcessor, interceptorWrapperProcessorFunction);
            }
            interceptedPipeline = interceptorWrapperProcessorFunction;
        }
        return stream -> Flux.from((Publisher)stream).doOnNext(this.beforeProcessors()).transform((Function)this.processingStrategy.onPipeline(interceptedPipeline)).doOnNext(this.afterProcessors()).onErrorContinue(MessagingException.class, (me, e) -> ((BaseEventContext)((MessagingException)me).getEvent().getContext()).error((Throwable)me));
    }

    private Consumer<CoreEvent> beforeProcessors() {
        return event -> {
            this.getStatistics().incReceivedEvents();
            FlowCallStack flowCallStack = event.getFlowCallStack();
            if (flowCallStack instanceof DefaultFlowCallStack) {
                DefaultFlowCallStack fs = (DefaultFlowCallStack)flowCallStack;
                fs.push(new FlowStackElement(this.getName(), this.getIdentifier(), null, this.getLocation(), this.getAnnotations()));
            }
            this.notificationFirer.dispatch(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(event, null, this), this.getName(), 1801));
            long startTime = System.currentTimeMillis();
            BaseEventContext baseEventContext = (BaseEventContext)event.getContext();
            baseEventContext.onComplete((response, throwable) -> {
                MessagingException messagingException = null;
                if (throwable != null) {
                    MessagingException msgException;
                    messagingException = throwable instanceof MessagingException ? (msgException = (MessagingException)throwable) : new MessagingException((CoreEvent)event, (Throwable)throwable, (Component)this);
                    response = messagingException.getEvent();
                }
                this.fireCompleteNotification((CoreEvent)response, messagingException);
                baseEventContext.getProcessingTime().ifPresent(time -> time.addFlowExecutionBranchTime(startTime));
            });
        };
    }

    private void fireCompleteNotification(CoreEvent event, MessagingException messagingException) {
        if (event != null) {
            FlowCallStack flowCallStack = event.getFlowCallStack();
            if (flowCallStack instanceof DefaultFlowCallStack) {
                DefaultFlowCallStack fs = (DefaultFlowCallStack)flowCallStack;
                fs.pop();
            }
        } else {
            LOGGER.warn("No event on flow completion", (Throwable)messagingException);
        }
        this.notificationFirer.dispatch(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(event, messagingException, this), this.getName(), 1804));
    }

    private Consumer<CoreEvent> afterProcessors() {
        return response -> {
            this.notificationFirer.dispatch(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(response, null, this), this.getName(), 1802));
            ((BaseEventContext)response.getContext()).success((CoreEvent)response);
        };
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain((Processor[])this.getProcessors().toArray(Processor[]::new));
    }

    @Override
    protected void doStartProcessingStrategy() throws MuleException {
        LOGGER.debug("Starting processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        super.doStartProcessingStrategy();
        this.startIfStartable(this.processingStrategy);
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        try {
            LOGGER.debug("Starting pipeline of flow '{}'...", (Object)this.getName());
            this.startIfStartable(this.pipeline);
            this.sink = this.processingStrategy.createSink(this, this.processFlowFunction());
        }
        catch (Exception e) {
            this.stopOnFailure(e);
            return;
        }
        this.canProcessMessage = true;
        if (this.source != null && this.getMuleContext().isStarted()) {
            try {
                if (this.componentInitialStateManager.mustStartMessageSource(this.source)) {
                    LOGGER.debug("Starting source of flow '{}'...", (Object)this.getName());
                    this.startIfStartable(this.source);
                } else {
                    LOGGER.info("Not starting source for '{}' because of {}", (Object)this.getName(), (Object)this.componentInitialStateManager);
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (Exception e) {
                this.stopOnFailure(e);
            }
        }
        this.updateFlowsSummaryStatistics(DefaultFlowsSummaryStatistics::incrementActiveTriggerFlow, DefaultFlowsSummaryStatistics::incrementActiveApikitFlow, DefaultFlowsSummaryStatistics::incrementActivePrivateFlow);
    }

    private void stopOnFailure(Exception e) throws MuleException {
        this.stopSafely(this::doStop);
        this.stopSafely(this::doStopProcessingStrategy);
        if (e instanceof MuleException) {
            MuleException muleException = (MuleException)e;
            throw muleException;
        }
        throw new DefaultMuleException(e);
    }

    private void stopSafely(CheckedRunnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw e;
            }
            LOGGER.warn(String.format("Stopping pipeline '%s' due to error on starting, but another exception was also found while shutting down: %s", this.getName(), e.getMessage()), (Throwable)e);
        }
    }

    public Consumer<CoreEvent> assertStarted() {
        return event -> {
            if (!this.canProcessMessage) {
                MessagingException exception = new MessagingException((CoreEvent)event, (Throwable)new LifecycleException(CoreMessages.isStopped(this.getName()), (Object)this));
                ((BaseEventContext)event.getContext()).error(exception);
                throw Exceptions.propagate((Throwable)exception);
            }
        };
    }

    @Override
    protected void doStop() throws MuleException {
        this.updateFlowsSummaryStatistics(DefaultFlowsSummaryStatistics::decrementActiveTriggerFlow, DefaultFlowsSummaryStatistics::decrementActiveApikitFlow, DefaultFlowsSummaryStatistics::decrementActivePrivateFlow);
        if (this.source != null) {
            this.stopSafely(() -> {
                if (this.componentInitialStateManager.mustStartMessageSource(this.source)) {
                    LOGGER.debug("Stopping source of flow '{}'...", (Object)this.getName());
                    this.stopIfStoppable(this.source);
                } else {
                    LOGGER.info("Not stopping source for '{}', it was not started because of {}", (Object)this.getName(), (Object)this.componentInitialStateManager);
                }
            });
        }
        this.canProcessMessage = false;
        LOGGER.debug("Stopping pipeline of flow '{}'...", (Object)this.getName());
        this.stopSafely(() -> this.disposeIfDisposable(this.sink));
        this.sink = null;
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doStopProcessingStrategy() throws MuleException {
        LOGGER.debug("Stopping processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        this.stopIfStoppable(this.processingStrategy);
        super.doStopProcessingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDispose() {
        this.updateFlowsSummaryStatistics(t -> t.decrementDeclaredTriggerFlow(this.getName()), t -> t.decrementDeclaredApikitFlow(this.getName()), t -> t.decrementDeclaredPrivateFlow(this.getName()));
        if (this.errorRouterForSourceResponseError != null) {
            AbstractPipeline abstractPipeline = this;
            synchronized (abstractPipeline) {
                if (this.errorRouterForSourceResponseError != null) {
                    this.disposeIfDisposable(this.errorRouterForSourceResponseError);
                }
            }
        }
        if (this.completionCallbackScheduler != null) {
            this.completionCallbackScheduler.stop();
        }
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.source);
        this.disposeIfDisposable(this.processingStrategy);
        super.doDispose();
    }

    private void updateFlowsSummaryStatistics(Consumer<DefaultFlowsSummaryStatistics> triggerFlowsUpdater, Consumer<DefaultFlowsSummaryStatistics> apikitflowsUpdater, Consumer<DefaultFlowsSummaryStatistics> privateFlowsUpdater) {
        if (this.triggerFlow) {
            triggerFlowsUpdater.accept(this.flowsSummaryStatistics);
        } else if (this.apikitFlow) {
            apikitflowsUpdater.accept(this.flowsSummaryStatistics);
        } else {
            privateFlowsUpdater.accept(this.flowsSummaryStatistics);
        }
        if (this.triggerFlow) {
            triggerFlowsUpdater.accept(this.flowsSummaryStatisticsV2);
        } else {
            switch (this.flowType) {
                case APIKIT: 
                case SOAPKIT: {
                    apikitflowsUpdater.accept(this.flowsSummaryStatisticsV2);
                    break;
                }
                case GENERIC: {
                    privateFlowsUpdater.accept(this.flowsSummaryStatisticsV2);
                }
            }
        }
    }

    protected Sink getSink() {
        return this.sink;
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public ProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    public AlertingSupport getAlertingSupport() {
        return this.alertingSupport;
    }

    @Override
    public void checkBackpressure(CoreEvent event) throws RuntimeException {
        try {
            this.backpressureStrategySelector.check(event);
        }
        catch (FlowBackPressureException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected void checkBackpressureReferenced(CoreEvent event) throws RuntimeException {
        try {
            this.backpressureStrategySelector.checkWithWaitStrategy(event);
        }
        catch (FlowBackPressureException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Map<BackPressureReason, FlowBackPressureException> getBackPressureExceptions() {
        return this.backPressureExceptions;
    }
}

