/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class StringToBoolean
extends AbstractTransformer
implements DiscoverableTransformer {
    private static final Map<String, Boolean> MAPPING = Map.of("true", Boolean.TRUE, "false", Boolean.FALSE, "yes", Boolean.TRUE, "no", Boolean.FALSE, "1", Boolean.TRUE, "0", Boolean.FALSE);
    private int priorityWeighting = 2;

    public StringToBoolean() {
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.BOOLEAN);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            if (this.isAllowNullReturn()) {
                return null;
            }
            throw new TransformerException(I18nMessageFactory.createStaticMessage("Unable to transform null to a primitive"));
        }
        String value = ((String)src).toLowerCase().trim();
        Boolean transformed = MAPPING.get(value);
        if (transformed != null) {
            return transformed;
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage(String.format("Cannot transform String '%s' to boolean. Valid types are: [%s]", value, MAPPING.keySet().stream().collect(Collectors.joining(", ")))));
    }

    @Override
    public void setReturnDataType(DataType type) {
        if (!Boolean.class.isAssignableFrom(type.getType())) {
            throw new IllegalArgumentException("This transformer only supports Boolean return types.");
        }
        super.setReturnDataType(type);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

