/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.SimpleConfigAttribute;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.dsl.api.xml.parser.XmlParsingConfiguration;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlGrammarPoolManager;
import org.w3c.dom.Document;

@Deprecated
public class XmlConfigurationProcessor {
    @Deprecated
    public static List<ConfigFile> processXmlConfiguration(XmlParsingConfiguration parsingConfiguration) {
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        if (!ArrayUtils.isEmpty((Object[])parsingConfiguration.getArtifactConfigResources())) {
            ArrayList<Pair<String, Supplier<InputStream>>> initialConfigFiles = new ArrayList<Pair<String, Supplier<InputStream>>>();
            for (ConfigResource artifactConfigResource : parsingConfiguration.getArtifactConfigResources()) {
                initialConfigFiles.add(new Pair<String, Supplier<InputStream>>(artifactConfigResource.getResourceName(), () -> {
                    try {
                        return artifactConfigResource.getInputStream();
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException(e);
                    }
                }));
            }
            XmlConfigurationProcessor.recursivelyResolveConfigFiles(initialConfigFiles, configFiles, parsingConfiguration).forEach(configFiles::add);
        }
        return Collections.unmodifiableList(configFiles);
    }

    private static List<ConfigFile> recursivelyResolveConfigFiles(List<Pair<String, Supplier<InputStream>>> configFilesToResolve, List<ConfigFile> alreadyResolvedConfigFiles, XmlParsingConfiguration parsingConfiguration) {
        ArrayList<ConfigFile> resolvedConfigFiles = new ArrayList<ConfigFile>(alreadyResolvedConfigFiles);
        configFilesToResolve.stream().filter(fileNameInputStreamPair -> !alreadyResolvedConfigFiles.stream().anyMatch(configFile -> configFile.getFilename().equals(fileNameInputStreamPair.getFirst()))).forEach(fileNameInputStreamPair -> {
            InputStream is = null;
            try {
                is = (InputStream)((Supplier)fileNameInputStreamPair.getSecond()).get();
                Document document = parsingConfiguration.getXmlConfigurationDocumentLoader().loadDocument(parsingConfiguration.getSaxParserFactory(), parsingConfiguration.getEntityResolver(), (String)fileNameInputStreamPair.getFirst(), (InputStream)((Supplier)fileNameInputStreamPair.getSecond()).get(), DefaultXmlGrammarPoolManager.getGrammarPool().orElse(null));
                ConfigLine mainConfigLine = new org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser(parsingConfiguration.getXmlNamespaceInfoProvider()).parse(document.getDocumentElement()).get();
                ConfigFile configFile = new ConfigFile((String)fileNameInputStreamPair.getFirst(), Arrays.asList(mainConfigLine));
                resolvedConfigFiles.add(configFile);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }
        });
        HashSet importedFiles = new HashSet();
        for (ConfigFile configFile : resolvedConfigFiles) {
            List<ConfigLine> rootConfigLines = configFile.getConfigLines();
            ConfigLine muleRootElementConfigLine = rootConfigLines.get(0);
            importedFiles.addAll(muleRootElementConfigLine.getChildren().stream().filter(configLine -> XmlApplicationParser.CORE_NAMESPACE.equals(configLine.getNamespaceUri()) && "import".equals(configLine.getIdentifier())).map(configLine -> {
                SimpleConfigAttribute fileConfigAttribute = configLine.getConfigAttributes().get("file");
                if (fileConfigAttribute == null) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("<import> does not have a file attribute defined. At file '%s', at line %s", configFile.getFilename(), configLine.getLineNumber())));
                }
                return fileConfigAttribute.getValue();
            }).map(value -> parsingConfiguration.getParsingPropertyResolver().resolveProperty((String)value)).filter(fileName -> !alreadyResolvedConfigFiles.stream().anyMatch(solvedConfigFile -> solvedConfigFile.getFilename().equals(fileName))).collect(Collectors.toList()));
        }
        if (importedFiles.isEmpty()) {
            return Collections.unmodifiableList(resolvedConfigFiles);
        }
        List<Pair<String, Supplier<InputStream>>> newConfigFilesToResolved = importedFiles.stream().map(importedFileName -> {
            Supplier<InputStream> inputStreamSupplier = () -> {
                try {
                    URL importedFile = parsingConfiguration.getResourceLocator().find((String)importedFileName, new XmlConfigurationProcessor()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not find imported resource '%s'", importedFileName))));
                    return IOUtils.getInputStreamWithCacheControl(importedFile);
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(e);
                }
            };
            return new Pair<String, Supplier<InputStream>>((String)importedFileName, inputStreamSupplier);
        }).collect(Collectors.toList());
        return XmlConfigurationProcessor.recursivelyResolveConfigFiles(newConfigFilesToResolved, resolvedConfigFiles, parsingConfiguration);
    }
}

