/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml.validator;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;

public class InnerConnectionParametersAsConnectionParameters
implements ExtensionModelValidator {
    private static final Pattern VARS_EXPRESSION_PATTERN = Pattern.compile("^#\\[vars\\.(\\w+)\\]$");

    @Override
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).ifPresent(mp -> mp.getGlobalElements().stream().forEach(globalElement -> globalElement.recursiveStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONNECTION)).forEach(connectionProvider -> {
            List<String> connectionProperties = this.resolveConnectionProperties((ComponentAst)connectionProvider);
            extensionModel.getConfigurationModels().forEach(configModel -> {
                Set<String> configParamsUsedForConnection = this.resolveConfigParamsUsedForConnection((ConfigurationModel)configModel, connectionProperties, this.resolveConnectionProviderParams((ConfigurationModel)configModel));
                if (!configParamsUsedForConnection.isEmpty()) {
                    problemsReporter.addWarning(new Problem(extensionModel.getConfigurationModels().get(0), "Connection provider for '" + (String)globalElement.getComponentId().orElse(null) + "' uses properties " + String.valueOf(configParamsUsedForConnection) + " that are defined at the config level, not within <connection>"));
                }
            });
        })));
    }

    private List<String> resolveConnectionProperties(ComponentAst connectionProvider) {
        return connectionProvider.recursiveStream().flatMap(comp -> comp.getParameters().stream()).filter(p -> p.getRawValue() != null).map(p -> {
            Matcher matcher = VARS_EXPRESSION_PATTERN.matcher(p.getRawValue());
            if (matcher.matches()) {
                return Optional.of(matcher.group(1));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Set<String> resolveConnectionProviderParams(ConfigurationModel configModel) {
        return configModel.getConnectionProviders().stream().map(pm -> pm.getName()).collect(Collectors.toSet());
    }

    private Set<String> resolveConfigParamsUsedForConnection(ConfigurationModel configModel, List<String> connectionProperties, Set<String> connectionProviderParams) {
        return configModel.getAllParameterModels().stream().map(pm -> pm.getName()).filter(name -> !connectionProviderParams.contains(name)).filter(connectionProperties::contains).collect(Collectors.toSet());
    }
}

