/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.metadata;

import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataTypeResolverUtils;
import org.mule.runtime.module.extension.internal.metadata.MuleOutputTypeResolverAdapter;

public class JavaOutputResolverModelParser
implements OutputResolverModelParser {
    private final Class<?> outputTypeResolverDeclarationClass;
    private final LazyValue<OutputTypeResolver<?>> instance;

    public JavaOutputResolverModelParser(Class<?> outputTypeResolverDeclarationClass) {
        this.outputTypeResolverDeclarationClass = outputTypeResolverDeclarationClass;
        this.instance = new LazyValue<Supplier<OutputTypeResolver>>(() -> this.instantiateResolver(outputTypeResolverDeclarationClass));
    }

    public JavaOutputResolverModelParser(OutputTypeResolver<?> outputTypeResolver) {
        this.outputTypeResolverDeclarationClass = outputTypeResolver.getClass();
        this.instance = new LazyValue(outputTypeResolver);
    }

    @Override
    public boolean hasOutputResolver() {
        return !JavaMetadataTypeResolverUtils.isNullResolver(this.outputTypeResolverDeclarationClass);
    }

    public OutputTypeResolver getOutputResolver() {
        return this.instance.get();
    }

    private OutputTypeResolver instantiateResolver(Class<?> factoryType) {
        try {
            Object resolver = factoryType.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (resolver instanceof org.mule.sdk.api.metadata.resolving.OutputTypeResolver) {
                return MuleOutputTypeResolverAdapter.from(resolver);
            }
            return (OutputTypeResolver)resolver;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of type " + factoryType.getName()), (Throwable)e);
        }
    }
}

