/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.internal.registry.AbstractSpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringRegistry
extends AbstractSpringRegistry {
    private final ConfigurationDependencyResolver configurationDependencyResolver;
    private ApplicationContext baseApplicationContext;

    public SpringRegistry(ApplicationContext baseApplicationContext, ApplicationContext applicationContext, MuleContext muleContext, ConfigurationDependencyResolver dependencyResolver, LifecycleInterceptor lifecycleInterceptor) {
        super(applicationContext, muleContext, lifecycleInterceptor);
        this.baseApplicationContext = baseApplicationContext;
        this.configurationDependencyResolver = dependencyResolver;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.addBeanFactoryPostProcessor(this.createBeforeInitialisationRegisteredObjectsPostProcessor());
        super.doInitialise();
        this.springContextInitialised.set(true);
    }

    private BeanDefinitionRegistryPostProcessor createBeforeInitialisationRegisteredObjectsPostProcessor() {
        return new BeanDefinitionRegistryPostProcessor(){

            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
                SpringRegistry.this.registeredBeanDefinitionsBeforeInitialization.entrySet().stream().forEach(beanDefinitionEntry -> registry.registerBeanDefinition((String)beanDefinitionEntry.getKey(), (BeanDefinition)beanDefinitionEntry.getValue()));
            }

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            }
        };
    }

    @Override
    protected void disposeContext() {
        if (((ConfigurableApplicationContext)this.baseApplicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.baseApplicationContext).close();
        }
        this.baseApplicationContext = null;
    }

    @Override
    protected <T> Map<String, T> lookupEntriesForLifecycleIncludingAncestors(Class<T> type) {
        LinkedHashMap<String, T> objects = new LinkedHashMap<String, T>();
        objects.putAll(this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, false, false, this.baseApplicationContext));
        if (this.springContextInitialised.get()) {
            objects.putAll(this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, false, false, this.getApplicationContext()));
        }
        return objects;
    }

    @Override
    public ConfigurationDependencyResolver getConfigurationDependencyResolver() {
        return this.configurationDependencyResolver;
    }
}

