/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.bootstrap.BootstrapService;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.builders.RegistryBootstrap;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.config.bootstrap.AbstractBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.mule.runtime.core.internal.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryBootstrap
implements RegistryBootstrap {
    static final String APPLY_TO_ARTIFACT_TYPE_PARAMETER_KEY = "applyToArtifactType";
    private static final String RETURN_CLASS_PROPERTY = "returnClass";
    private static final String MIME_TYPE_PROPERTY = "mimeType";
    public static final String TRANSFORMER_KEY = ".transformer.";
    public static final String OBJECT_KEY = ".object.";
    public static final String SINGLE_TX = ".singletx.";
    public static final Predicate<String> TRANSFORMER_PREDICATE = propertyKey -> propertyKey.contains(TRANSFORMER_KEY);
    public static final Predicate<String> BINDING_PROVIDER_PREDICATE = propertyKey -> propertyKey.endsWith(".binding.provider") || propertyKey.endsWith("FunctionsProvider");
    protected ArtifactType artifactType = ArtifactType.APP;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private BootstrapServiceDiscoverer bootstrapServiceDiscoverer;
    private final Predicate<String> propertyKeyfilter;

    public AbstractRegistryBootstrap(ArtifactType artifactType, BootstrapServiceDiscoverer bootstrapServiceDiscoverer, Predicate<String> propertyKeyfilter) {
        this.artifactType = artifactType;
        this.bootstrapServiceDiscoverer = bootstrapServiceDiscoverer;
        this.propertyKeyfilter = propertyKeyfilter;
    }

    @Override
    public void initialise() throws InitialisationException {
        List<BootstrapService> bootstrapServices;
        try {
            bootstrapServices = this.bootstrapServiceDiscoverer.discover();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        int objectCounter = 1;
        LinkedList<TransformerBootstrapProperty> transformers = new LinkedList<TransformerBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> bindingProviders = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> namedObjects = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> unnamedObjects = new LinkedList<ObjectBootstrapProperty>();
        for (BootstrapService bootstrapService : bootstrapServices) {
            Properties bootstrapProperties = bootstrapService.getProperties();
            for (Map.Entry<Object, Object> entry : bootstrapProperties.entrySet()) {
                this.logger.debug("Processing registryBootstrap entry: {}={}...", entry.getKey(), entry.getValue());
                String propertyKey = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (!this.propertyKeyfilter.test(propertyKey)) {
                    this.logger.debug("Skipped registryBootstrap entry: {}", entry.getKey());
                    continue;
                }
                if (propertyKey.contains(OBJECT_KEY)) {
                    this.logger.debug("Unnamed registryBootstrap entry: {}", entry.getKey());
                    String newKey = propertyKey.substring(0, propertyKey.lastIndexOf(".")) + objectCounter++;
                    unnamedObjects.add(this.createObjectBootstrapProperty(bootstrapService, newKey, propertyValue));
                    continue;
                }
                if (TRANSFORMER_PREDICATE.test(propertyKey)) {
                    this.logger.debug("Transformer registryBootstrap entry: {}", entry.getKey());
                    transformers.add(this.createTransformerBootstrapProperty(bootstrapService, propertyValue));
                    continue;
                }
                if (BINDING_PROVIDER_PREDICATE.test(propertyKey)) {
                    this.logger.debug("Binding Provider registryBootstrap entry: {}", entry.getKey());
                    bindingProviders.add(this.createObjectBootstrapProperty(bootstrapService, propertyKey, propertyValue));
                    continue;
                }
                this.logger.debug("Named registryBootstrap entry: {}", entry.getKey());
                namedObjects.add(this.createObjectBootstrapProperty(bootstrapService, propertyKey, propertyValue));
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects);
            this.registerTransformers(transformers);
            this.registerObjects(bindingProviders);
            this.registerObjects(namedObjects);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private TransformerBootstrapProperty createTransformerBootstrapProperty(BootstrapService bootstrapService, String propertyValue) {
        int i;
        String name = null;
        String transString = propertyValue;
        String returnClassName = null;
        int index = transString.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(index + 1), ',');
            name = p.getProperty("name", null);
            returnClassName = p.getProperty(RETURN_CLASS_PROPERTY, null);
        }
        String mime = null;
        if (returnClassName != null && (i = returnClassName.indexOf(":")) > -1) {
            mime = returnClassName.substring(i + 1);
            returnClassName = returnClassName.substring(0, i);
        }
        String className = index == -1 ? transString : transString.substring(0, index);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(MIME_TYPE_PROPERTY, mime);
        properties.put(RETURN_CLASS_PROPERTY, returnClassName);
        return new TransformerBootstrapProperty(bootstrapService, new HashSet<ArtifactType>(Arrays.asList(ArtifactType.APP, ArtifactType.POLICY)), name, className, returnClassName, mime);
    }

    private ObjectBootstrapProperty createObjectBootstrapProperty(BootstrapService bootstrapService, String propertyKey, String propertyValue) {
        String className;
        Set<ArtifactType> artifactTypesParameterValue = new HashSet<ArtifactType>(Arrays.asList(ArtifactType.APP, ArtifactType.DOMAIN, ArtifactType.POLICY));
        String value = propertyValue;
        int index = value.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(value.substring(index + 1), ',');
            if (p.containsKey(APPLY_TO_ARTIFACT_TYPE_PARAMETER_KEY)) {
                artifactTypesParameterValue = Arrays.stream(((String)p.get(APPLY_TO_ARTIFACT_TYPE_PARAMETER_KEY)).split("\\/")).map(AbstractRegistryBootstrap::fromString).collect(Collectors.toSet());
            }
            className = value.substring(0, index);
        } else {
            className = value;
        }
        return new ObjectBootstrapProperty(bootstrapService, artifactTypesParameterValue, propertyKey, className);
    }

    private static ArtifactType fromString(String artifactTypeAsString) {
        for (ArtifactType artifactType : ArtifactType.values()) {
            if (!artifactType.getArtifactTypeAsString().equals(artifactTypeAsString)) continue;
            return artifactType;
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No artifact type found for value: " + artifactTypeAsString));
    }

    private void registerUnnamedObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        try {
            if (!bootstrapProperty.getArtifactTypes().contains((Object)this.artifactType)) {
                return;
            }
            this.doRegisterObject(bootstrapProperty);
        }
        catch (InvocationTargetException e) {
            Throwable cause = ExceptionUtils.getCause((Throwable)e);
            this.throwException(cause, bootstrapProperty);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException e) {
            this.throwException(e, bootstrapProperty);
        }
    }

    private void registerTransformers(List<TransformerBootstrapProperty> props) throws Exception {
        for (TransformerBootstrapProperty bootstrapProperty : props) {
            try {
                Class transformerClass = bootstrapProperty.getService().forName(bootstrapProperty.getClassName());
                Class returnClass = null;
                String returnClassString = bootstrapProperty.getReturnClassName();
                if (returnClassString != null) {
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : bootstrapProperty.getService().forName(returnClassString);
                }
                this.doRegisterTransformer(bootstrapProperty, returnClass, transformerClass);
            }
            catch (InvocationTargetException e) {
                Throwable cause = ExceptionUtils.getCause((Throwable)e);
                this.throwException(cause, bootstrapProperty);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.throwException(e, bootstrapProperty);
            }
        }
    }

    protected abstract void doRegisterTransformer(TransformerBootstrapProperty var1, Class<?> var2, Class<? extends Transformer> var3) throws Exception;

    protected abstract void doRegisterObject(ObjectBootstrapProperty var1) throws Exception;

    private void throwException(Throwable t, AbstractBootstrapProperty bootstrapProperty) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(t);
    }
}

