/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.routing.split.DuplicateMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentMessageValidator
extends AbstractComponent
implements Processor,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentMessageValidator.class);
    protected MuleContext muleContext;
    @Inject
    private MuleConfiguration muleConfiguration;
    private ExpressionManager expressionManager;
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    private FeatureFlaggingService featureFlaggingService;
    protected volatile ObjectStore<String> store;
    protected ObjectStore<String> privateStore;
    protected String storePrefix;
    protected String idExpression = String.format("%s%s%s", "#[", "correlationId", "]");
    protected String valueExpression = String.format("%s%s%s", "#[", "correlationId", "]");
    private CompiledExpression compiledIdExpression;
    private CompiledExpression compiledValueExpression;
    private boolean rethrowEnabled;

    public void setRethrowEnabled(boolean rethrowEnabled) {
        this.rethrowEnabled = rethrowEnabled;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s.%s.%s.%s", this.muleConfiguration.getId(), this.getLocation().getRootContainerName(), this.getClass().getName(), UUID.randomUUID());
        }
        this.setupObjectStore();
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.RETHROW_EXCEPTIONS_IN_IDEMPOTENT_MESSAGE_VALIDATOR)) {
            this.setRethrowEnabled(true);
        }
        this.compiledIdExpression = ExpressionLanguageUtils.compile(this.idExpression, this.expressionManager);
        this.compiledValueExpression = ExpressionLanguageUtils.compile(this.valueExpression, this.expressionManager);
    }

    private void setupObjectStore() throws InitialisationException {
        if (this.store != null && this.privateStore != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Ambiguous definition of object store, both reference and private were configured"), (Initialisable)this);
        }
        if (this.store == null) {
            this.store = this.privateStore == null ? this.createMessageIdStore() : this.privateStore;
        }
        LifecycleUtils.initialiseIfNeeded(this.store, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.store);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.store);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.store, LOGGER);
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        return this.objectStoreManager.createObjectStore(this.storePrefix, ObjectStoreSettings.builder().persistent(false).entryTtl(TimeUnit.MINUTES.toMillis(5L)).expirationInterval(TimeUnit.SECONDS.toMillis(6L)).build());
    }

    protected String getValueForEvent(ExpressionLanguageSession session) {
        return this.evaluateString(session, this.compiledValueExpression);
    }

    protected String getIdForEvent(ExpressionLanguageSession session) {
        return this.evaluateString(session, this.compiledIdExpression);
    }

    private String evaluateString(ExpressionLanguageSession session, CompiledExpression expression) {
        return (String)session.evaluate(expression, DataType.STRING).getValue();
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore<String> getObjectStore() {
        return this.store;
    }

    public void setObjectStore(ObjectStore<String> store) {
        this.store = store;
    }

    private boolean accept(CoreEvent event) {
        BindingContext bindingContext = event.asBindingContext();
        ExpressionManagerSession session = this.expressionManager.openSession(bindingContext);
        try {
            boolean bl = this.doAccept(event, session);
            if (session != null) {
                session.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ExpressionRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.warn("Could not retrieve Id or Value for event: " + e.getMessage());
                return false;
            }
        }
    }

    private boolean doAccept(CoreEvent event, ExpressionLanguageSession session) throws MuleException {
        String id = this.getIdForEvent(session);
        String value = this.getValueForEvent(session);
        if (event != null && this.isNewMessage(event, id)) {
            try {
                this.store.store(id, value);
                return true;
            }
            catch (ObjectAlreadyExistsException ex) {
                return false;
            }
            catch (ObjectStoreNotAvailableException e) {
                LOGGER.error("ObjectStore not available: " + e.getMessage());
                return false;
            }
            catch (ObjectStoreException e) {
                LOGGER.warn("ObjectStore exception: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acceptWithRethrowExceptionsInIdempotentMessageValidator(CoreEvent event) throws MuleException {
        BindingContext bindingContext = event.asBindingContext();
        try (ExpressionManagerSession session = this.expressionManager.openSession(bindingContext);){
            String id = this.getIdForEvent(session);
            String value = this.getValueForEvent(session);
            if (event != null && this.isNewMessage(event, id)) {
                this.store.store(id, value);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectAlreadyExistsException ex) {
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Could not retrieve Id or Value for event: " + e.getMessage());
            throw e;
        }
    }

    private boolean rethrowIfFeatureFlagEnabled(MuleException e) throws MuleException {
        if (this.rethrowEnabled) {
            throw e;
        }
        return false;
    }

    @Override
    public final CoreEvent process(CoreEvent event) throws MuleException {
        if (this.rethrowEnabled ? this.acceptWithRethrowExceptionsInIdempotentMessageValidator(event) : this.accept(event)) {
            return event;
        }
        throw new DuplicateMessageException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNewMessage(CoreEvent event, String id) throws MuleException {
        try {
            if (this.store == null) {
                IdempotentMessageValidator idempotentMessageValidator = this;
                synchronized (idempotentMessageValidator) {
                    this.initialise();
                }
            }
            return !this.store.contains(id);
        }
        catch (MuleException e) {
            LOGGER.error("Exception attempting to determine idempotency of incoming message for " + this.getLocation().getRootContainerName() + " from the connector " + event.getContext().getOriginatingLocation().getComponentIdentifier().getIdentifier().getNamespace(), (Throwable)e);
            return this.rethrowIfFeatureFlagEnabled(e);
        }
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    public void setPrivateObjectStore(ObjectStore<String> privateStore) {
        this.privateStore = privateStore;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    @Inject
    public void setFeatureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }
}

