/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;

public class ProvidedObjectStoreWrapper<T extends Serializable>
extends TemplateObjectStore<T>
implements Disposable {
    private ObjectStore<T> wrapped;
    private final boolean provided;

    public ProvidedObjectStoreWrapper(ObjectStore<T> providedObjectStore, Supplier<ObjectStore> objectStoreSupplier) {
        if (providedObjectStore == null) {
            this.provided = false;
            this.wrapped = objectStoreSupplier.get();
        } else {
            this.provided = true;
            this.wrapped = providedObjectStore;
        }
    }

    @Override
    protected boolean doContains(String key) throws ObjectStoreException {
        return this.getWrapped().contains(key);
    }

    @Override
    protected void doStore(String key, T value) throws ObjectStoreException {
        this.getWrapped().store(key, value);
    }

    @Override
    protected T doRetrieve(String key) throws ObjectStoreException {
        return this.getWrapped().retrieve(key);
    }

    @Override
    protected T doRemove(String key) throws ObjectStoreException {
        return this.getWrapped().remove(key);
    }

    @Override
    public boolean isPersistent() {
        return this.getWrapped().isPersistent();
    }

    @Override
    public boolean isDistributed() {
        return this.getWrapped().isDistributed();
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.getWrapped().clear();
    }

    @Override
    public void dispose() {
        if (!this.provided && this.wrapped != null && this.wrapped instanceof Disposable) {
            ((Disposable)((Object)this.wrapped)).dispose();
        }
        this.wrapped = null;
    }

    @Override
    public void open() throws ObjectStoreException {
        this.getWrapped().open();
    }

    @Override
    public void close() throws ObjectStoreException {
        this.getWrapped().close();
    }

    @Override
    public List<String> allKeys() throws ObjectStoreException {
        return this.getWrapped().allKeys();
    }

    @Override
    public Map<String, T> retrieveAll() throws ObjectStoreException {
        return this.getWrapped().retrieveAll();
    }

    protected ObjectStore<T> getWrapped() {
        return this.wrapped;
    }
}

