/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.singleapp;

import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DefaultArtifactDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentMuleContextListenerFactory;
import org.mule.runtime.module.deployment.internal.util.ObservableList;

public class SingleAppApplicationDeployerBuilder {
    private final Supplier<SchedulerService> artifactStartExecutorSupplier;
    private ObservableList<Application> applications;
    private DefaultApplicationFactory applicationFactory;
    private DefaultArtifactDeployer applicationDeployer;
    private DeploymentListener applicationDeploymentListener;

    private SingleAppApplicationDeployerBuilder(Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
    }

    public static SingleAppApplicationDeployerBuilder getSingleAppApplicationDeployerBuilder(Supplier<SchedulerService> artifactStartExecutorSupplier) {
        return new SingleAppApplicationDeployerBuilder(artifactStartExecutorSupplier);
    }

    public DefaultArchiveDeployer<ApplicationDescriptor, Application> build() {
        return new DefaultArchiveDeployer<ApplicationDescriptor, Application>(this.applicationDeployer, this.applicationFactory, this.applications, ArtifactDeploymentTemplate.NOP_ARTIFACT_DEPLOYMENT_TEMPLATE, new DeploymentMuleContextListenerFactory(this.applicationDeploymentListener), this.artifactStartExecutorSupplier);
    }

    public SingleAppApplicationDeployerBuilder withApplications(List<Application> applications) {
        this.applications = new ObservableList<Application>(applications);
        return this;
    }

    public SingleAppApplicationDeployerBuilder withApplicationFactory(DefaultApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
        return this;
    }

    public SingleAppApplicationDeployerBuilder withApplicationDeployer(DefaultArtifactDeployer<Application> applicationDeployer) {
        this.applicationDeployer = applicationDeployer;
        return this;
    }

    public SingleAppApplicationDeployerBuilder withApplicationDeploymentListener(DeploymentListener applicationDeploymentListener) {
        this.applicationDeploymentListener = applicationDeploymentListener;
        return this;
    }
}

