/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.Set;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class OperationParametersTypeModelValidator
implements ExtensionModelValidator {
    private final Set<String> forbiddenTypes = Set.of(CoreEvent.class.getName(), Message.class.getName());

    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel model) {
                model.getAllParameterModels().forEach(parameterModel -> {
                    MetadataType parameterType = parameterModel.getType();
                    if (parameterType.getMetadataFormat().equals(MetadataFormat.JAVA) && this.isForbiddenType(parameterType)) {
                        problemsReporter.addError(new Problem(model, String.format("Operation '%s' contains parameter '%s' of type '%s' which is forbidden", model.getName(), parameterModel.getName(), ExtensionMetadataTypeUtils.getId(parameterType).get())));
                    }
                });
            }

            private boolean isForbiddenType(MetadataType parameterType) {
                return ExtensionMetadataTypeUtils.getId(parameterType).map(OperationParametersTypeModelValidator.this.forbiddenTypes::contains).orElse(false);
            }
        }.walk(extensionModel);
    }
}

