/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.result;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.event.EventUtils;
import org.mule.runtime.core.internal.streaming.StreamingUtils;
import org.mule.runtime.core.internal.util.collection.TransformingCollection;
import org.mule.runtime.core.internal.util.collection.TransformingIterator;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultCollection;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultIterator;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.internal.util.message.SdkResultAdapter;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.result.ReturnDelegate;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.runtime.operation.Result;

public abstract class AbstractReturnDelegate
implements ReturnDelegate {
    private boolean returnsListOfMessages = false;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();
    private final Charset defaultEncoding;

    protected AbstractReturnDelegate(ComponentModel componentModel, ArtifactEncoding artifactEncoding) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)((Object)componentModel);
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.defaultEncoding = artifactEncoding.getDefaultEncoding();
        this.defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType(componentModel);
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        if (value instanceof Event) {
            return ((Event)value).getMessage();
        }
        if (value instanceof org.mule.runtime.extension.api.runtime.operation.Result) {
            value = new SdkResultAdapter((org.mule.runtime.extension.api.runtime.operation.Result)value);
        }
        Map<String, Object> params = operationContext.getParameters();
        MediaType contextMimeTypeParam = this.getContextMimeType(params);
        Charset contextEncodingParam = this.getContextEncoding(params);
        MediaType mediaType = this.resolveMediaType(value, contextMimeTypeParam, contextEncodingParam);
        CoreEvent event = operationContext.getEvent();
        CursorProviderFactory cursorProviderFactory = operationContext.getCursorProviderFactory();
        ComponentLocation originatingLocation = operationContext.getComponent().getLocation();
        if (value instanceof Result) {
            ConnectionHandler connectionHandler;
            Result resultValue = (Result)value;
            if (resultValue.getOutput() instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
                resultValue = resultValue.copy().output(new ConnectedInputStreamWrapper((InputStream)resultValue.getOutput(), connectionHandler, this.getDecrementActiveComponentTask(operationContext))).build();
            }
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage(resultValue, mediaType, cursorProviderFactory, event, this.returnHandler.getDataType(), originatingLocation) : MessageUtils.toMessage(resultValue, mediaType, cursorProviderFactory, event, originatingLocation);
        }
        PayloadMediaTypeResolver payloadMediaTypeResolver = new PayloadMediaTypeResolver(this.defaultEncoding, this.defaultMediaType, contextEncodingParam, contextMimeTypeParam);
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = this.toLazyMessageCollection((Collection)value, operationContext, event);
            value = MessageUtils.messageCollection(new MediaTypeDecoratedResultCollection((Collection)value, payloadMediaTypeResolver), cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            TransformingIterator<Result> iterator = TransformingIterator.from((Iterator)value, this.toResult(operationContext, event));
            value = MessageUtils.messageIterator(new MediaTypeDecoratedResultIterator(iterator, payloadMediaTypeResolver), cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
        }
        value = this.doStreamingContent(value, operationContext, cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
        Message.Builder messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)value, Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    private Collection<Result> toLazyMessageCollection(Collection<?> values, ExecutionContextAdapter operationContext, CoreEvent event) {
        return new TransformingCollection<Result>(values, this.toResult(operationContext, event));
    }

    private Function<Object, Result> toResult(ExecutionContextAdapter operationContext, CoreEvent event) {
        return value -> {
            Result result;
            if (value instanceof Result) {
                result = (SdkResultAdapter)value;
            } else if (value instanceof org.mule.runtime.extension.api.runtime.operation.Result) {
                result = new SdkResultAdapter((org.mule.runtime.extension.api.runtime.operation.Result)value);
            } else {
                throw new IllegalArgumentException("Result was expected but value found instead: " + value.getClass().getName());
            }
            Object patt11105$temp = ((Result)result).getOutput();
            if (patt11105$temp instanceof InputStream) {
                InputStream streamOutput = (InputStream)patt11105$temp;
                ConnectionHandler connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM");
                if (connectionHandler != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
                    result = ((Result)result).copy().output(StreamingUtils.streamingContent((Object)new ConnectedInputStreamWrapper(streamOutput, connectionHandler, this.getDecrementActiveComponentTask(operationContext)), operationContext.getCursorProviderFactory(), EventUtils.getRoot(event.getContext()), operationContext.getComponent().getLocation())).build();
                }
            }
            return result;
        };
    }

    private MediaType getContextMimeType(Map<String, Object> params) {
        String mimeType = (String)params.get("outputMimeType");
        return mimeType != null ? MediaType.parseDefinedInApp(mimeType) : null;
    }

    private Charset getContextEncoding(Map<String, Object> params) {
        String encoding = (String)params.get("outputEncoding");
        return encoding != null ? MediaTypeUtils.parseCharset(encoding) : null;
    }

    private Object doStreamingContent(Object value, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        ConnectionHandler connectionHandler;
        if (value instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
            value = new ConnectedInputStreamWrapper((InputStream)value, connectionHandler, this.getDecrementActiveComponentTask(operationContext));
        }
        return StreamingUtils.streamingContent(value, cursorProviderFactory, eventContext, originatingLocation);
    }

    protected MediaType resolveMediaType(Object value, MediaType contextMimeType, Charset contextEncoding) {
        if (contextEncoding == null) {
            contextEncoding = this.defaultEncoding;
        }
        if (contextMimeType == null) {
            Optional<MediaType> optionalMediaType;
            MediaType mediaType = this.defaultMediaType;
            if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = optionalMediaType.get()).getCharset().isPresent()) {
                contextEncoding = mediaType.getCharset().orElse(contextEncoding);
            }
            contextMimeType = mediaType;
        }
        return contextMimeType.withCharset(contextEncoding);
    }

    private Runnable getDecrementActiveComponentTask(ExecutionContextAdapter executionContext) {
        MutableConfigurationStats mutableStats = MuleExtensionUtils.getMutableConfigurationStats(executionContext);
        return mutableStats != null ? mutableStats::discountActiveComponent : null;
    }

    protected class ConnectedInputStreamWrapper
    extends ProxyInputStream {
        private final ConnectionHandler<?> connectionHandler;
        private final Runnable onClose;
        private AtomicBoolean alreadyClosed;

        private ConnectedInputStreamWrapper(InputStream delegate, ConnectionHandler<?> connectionHandler, Runnable onClose) {
            super(delegate);
            this.alreadyClosed = new AtomicBoolean(false);
            this.connectionHandler = connectionHandler;
            this.onClose = onClose;
        }

        protected void afterRead(int n) throws IOException {
            if (n == -1) {
                this.close();
            }
        }

        public void close() throws IOException {
            try {
                super.close();
                this.in = new ClosedInputStream();
            }
            finally {
                try {
                    this.connectionHandler.release();
                }
                finally {
                    if (this.onClose != null && this.alreadyClosed.compareAndSet(false, true)) {
                        this.onClose.run();
                    }
                }
            }
        }
    }
}

