/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.maven.pom.parser.api.BundleDescriptorCreationException;
import org.mule.maven.pom.parser.internal.util.FileUtils;

public class MavenUtils {
    private static final String META_INF = "META-INF";
    private static final String MULE_ARTIFACT_FOLDER = "META-INF" + File.separator + "mule-artifact";
    private static final String MULE_PLUGIN_POM = "pom.xml";

    public static Model getPomModel(Path artifact) {
        if (Files.isDirectory(artifact, new LinkOption[0])) {
            return MavenUtils.getPomModelFolder(artifact);
        }
        if (FilenameUtils.getExtension((String)artifact.getFileName().toString()).equals("jar")) {
            URL pomURL = FileUtils.getPomUrlFromJar(artifact);
            return MavenUtils.getPomModelFromJar(pomURL);
        }
        return MavenUtils.getPomModelFromFile(artifact);
    }

    public static Model getPomModelFolder(Path artifactFolder) {
        Path mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        return MavenUtils.getPomModelFromFile(mulePluginPom);
    }

    public static Model getPomModelFromJar(URL pomUrl) {
        String pomFilePath = MULE_ARTIFACT_FOLDER + File.separator + MULE_PLUGIN_POM;
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(new ByteArrayInputStream(FileUtils.loadFileContentFrom(pomUrl).get()));
            return model;
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' for the artifact '%s'", pomFilePath, pomUrl.getFile()), e);
        }
    }

    public static Model getPomModelFromFile(Path pomFile) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (BufferedReader mulePluginPomFilerReader = Files.newBufferedReader(pomFile);){
            model = reader.read(mulePluginPomFilerReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' in '%s'", pomFile.getFileName().toString(), pomFile.getParent().toAbsolutePath().toString()), e);
        }
        model.setPomFile(pomFile.toFile());
        return model;
    }

    public static Path lookupPomFromMavenLocation(Path artifactFolder) {
        Path mulePluginPom = null;
        Path lookupFolder = artifactFolder.resolve(META_INF).resolve("maven");
        while (lookupFolder != null && Files.exists(lookupFolder, new LinkOption[0])) {
            List directories;
            Path possiblePomLocation = lookupFolder.resolve(MULE_PLUGIN_POM);
            if (Files.exists(possiblePomLocation, new LinkOption[0])) {
                mulePluginPom = possiblePomLocation;
                break;
            }
            try (Stream<Path> directoriesStream = Files.list(lookupFolder);){
                directories = directoriesStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            MavenUtils.checkState(directories != null && !directories.isEmpty(), String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.toAbsolutePath().toString(), artifactFolder.toAbsolutePath().toString()));
            MavenUtils.checkState(directories.size() == 1, String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.toAbsolutePath().toString(), artifactFolder.toAbsolutePath().toString()));
            lookupFolder = (Path)directories.get(0);
        }
        if (mulePluginPom == null || !Files.exists(mulePluginPom, new LinkOption[0])) {
            throw new IllegalStateException(String.format("The maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getFileName().toString()));
        }
        return mulePluginPom;
    }

    public static String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        MavenUtils.checkState(attributeDom != null, String.format("'%s' element not declared at '%s' in the pom file", attributeName, tag.toString()));
        String attributeValue = attributeDom.getValue().trim();
        MavenUtils.checkState(!StringUtils.isEmpty((String)attributeValue), String.format("'%s' was defined but has an empty value at '%s' declared in the pom file", attributeName, tag.toString()));
        return attributeValue;
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

