/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ParameterDslDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.LAYOUT;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            ExtensionDeclaration extensionDeclaration;
            TypeCatalog typeCatalog;
            {
                this.extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
                this.typeCatalog = extensionLoadingContext.getDslResolvingContext().getTypeCatalog();
            }

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, final ParameterDeclaration declaration) {
                final ParameterDslConfiguration dslConfiguration = declaration.getDslConfiguration();
                final ParameterDslConfiguration.Builder builder = ParameterDslConfiguration.builder(dslConfiguration);
                final boolean isContent = declaration.getRole() == ParameterRole.PRIMARY_CONTENT || declaration.getRole() == ParameterRole.CONTENT;
                this.resolveType(this.typeCatalog, declaration).accept(new MetadataTypeVisitor(){

                    @Override
                    protected void defaultVisit(MetadataType metadataType) {
                        builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && isContent).allowTopLevelDefinition(false).allowsReferences(false);
                    }

                    @Override
                    public void visitString(StringType stringType) {
                        boolean isText = declaration.getLayoutModel() != null && declaration.getLayoutModel().isText();
                        builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (isText || isContent)).allowTopLevelDefinition(false).allowsReferences(false);
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        MetadataType genericType = arrayType.getType();
                        boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(arrayType, declaration.getExpressionSupport(), dslConfiguration, isContent);
                        boolean isWrapped = this.allowsInlineAsWrappedType(genericType, typeCatalog);
                        builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (supportsInline || isWrapped)).allowTopLevelDefinition(dslConfiguration.allowTopLevelDefinition()).allowsReferences(dslConfiguration.allowsReferences());
                    }

                    @Override
                    public void visitAnyType(AnyType anyType) {
                        if (ExtensionMetadataTypeUtils.isReferableType(anyType)) {
                            builder.allowsReferences(dslConfiguration.allowsReferences()).allowTopLevelDefinition(false).allowsInlineDefinition(false);
                        } else {
                            this.defaultVisit(anyType);
                        }
                    }

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                            builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition());
                        } else if (!declaration.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()) {
                            boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(objectType, declaration.getExpressionSupport(), dslConfiguration, isContent);
                            boolean isWrapped = this.allowsInlineAsWrappedType(objectType, typeCatalog);
                            builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (supportsInline || isWrapped));
                        }
                        builder.allowTopLevelDefinition(dslConfiguration.allowTopLevelDefinition()).allowsReferences(dslConfiguration.allowsReferences());
                    }

                    @Override
                    public void visitUnion(UnionType unionType) {
                        unionType.getTypes().forEach(type -> type.accept(this));
                    }
                });
                declaration.setDslConfiguration(builder.build());
            }

            private MetadataType resolveType(TypeCatalog typeCatalog, ParameterDeclaration declaration) {
                return MetadataTypeUtils.getTypeId(declaration.getType()).map(typeId -> typeCatalog.getType((String)typeId).orElse(this.extensionDeclaration.getTypeById((String)typeId))).map(type -> {
                    if (type instanceof ObjectType) {
                        Map normalizedAnnotationsByClass = type.getAnnotations().stream().collect(Collectors.toMap(Object::getClass, Function.identity(), (u, v) -> v, LinkedHashMap::new));
                        declaration.getType().getAnnotation(ClassInformationAnnotation.class).ifPresent(paramClassInfo -> normalizedAnnotationsByClass.put(ClassInformationAnnotation.class, paramClassInfo));
                        declaration.getType().getAnnotation(ParameterDslAnnotation.class).ifPresent(paramClassInfo -> normalizedAnnotationsByClass.put(ParameterDslAnnotation.class, paramClassInfo));
                        return new DefaultObjectType(((ObjectType)type).getFields(), ((ObjectType)type).isOrdered(), ((ObjectType)type).getOpenRestriction().orElse(null), type.getMetadataFormat(), normalizedAnnotationsByClass);
                    }
                    return type;
                }).orElse(declaration.getType());
            }

            boolean allowsInlineAsWrappedType(MetadataType type, TypeCatalog typeCatalog) {
                return this.isSubTypeBase(type) || DslSyntaxUtils.typeRequiresWrapperElement(type, typeCatalog);
            }

            private boolean isSubTypeBase(MetadataType type) {
                Optional<String> typeIdOptional = MetadataTypeUtils.getTypeId(type);
                return this.extensionDeclaration.getSubTypes().stream().map(subType -> subType.getBaseType()).anyMatch(baseType -> typeIdOptional.map(typeId -> MetadataTypeUtils.getTypeId(baseType).map(baseTypeId -> typeId.equals(baseTypeId)).orElse(false)).orElseGet(() -> baseType.equals(type)));
            }
        });
    }
}

