/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;

public class DeployableClassLoaderConfigurationBuilder
extends ClassLoaderConfiguration.ClassLoaderConfigurationBuilder {
    private final DeployableProjectModel deployableProjectModel;

    public DeployableClassLoaderConfigurationBuilder(DeployableProjectModel deployableProjectModel) {
        if (deployableProjectModel.getDescriptor().getClassifier().filter(Predicate.not(ArtifactType.APP.getMavenArtifactClassifier()::equals)).filter(Predicate.not(ArtifactType.DOMAIN.getMavenArtifactClassifier()::equals)).isPresent()) {
            throw new IllegalArgumentException("Model must be for a '" + ArtifactType.APP.getMavenArtifactClassifier() + "' or '" + ArtifactType.DOMAIN.getMavenArtifactClassifier() + "' for deployables.");
        }
        this.deployableProjectModel = deployableProjectModel;
    }

    @Override
    public ClassLoaderConfiguration build() {
        this.exportSharedLibrariesResourcesAndPackages();
        this.processAdditionalPluginLibraries();
        return super.build();
    }

    private void exportSharedLibrariesResourcesAndPackages() {
        this.deployableProjectModel.getDependencies().stream().filter(dep -> this.deployableProjectModel.getSharedLibraries().contains(dep.getDescriptor())).forEach(sharedDep -> {
            this.exportingPackages((Set<String>)(sharedDep.getPackages() == null ? Collections.emptySet() : new HashSet<String>(sharedDep.getPackages())));
            this.exportingResources((Set<String>)(sharedDep.getResources() == null ? Collections.emptySet() : new HashSet<String>(sharedDep.getResources())));
        });
    }

    private void processAdditionalPluginLibraries() {
        this.deployableProjectModel.getAdditionalPluginDependencies().entrySet().forEach(this::updateDependency);
    }

    private void updateDependency(Map.Entry<BundleDescriptor, List<BundleDependency>> plugin) {
        this.dependencies.stream().filter(pluginDependency -> ((BundleDescriptor)plugin.getKey()).equals(pluginDependency.getDescriptor())).findFirst().ifPresent(pluginDependency -> this.replaceBundleDependency((BundleDependency)pluginDependency, this.createExtendedBundleDependency((BundleDependency)pluginDependency, ((List)plugin.getValue()).stream().collect(Collectors.toList()))));
    }

    private BundleDependency createExtendedBundleDependency(BundleDependency original, List<BundleDependency> additionalPluginDependencies) {
        return BundleDependency.builder(original).setAdditionalDependencies(additionalPluginDependencies).build();
    }

    private void replaceBundleDependency(BundleDependency original, BundleDependency modified) {
        this.dependencies.remove(original);
        this.dependencies.add(modified);
    }
}

