/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.deployment.model.api.plugin.resolver.DuplicateExportedPackageException;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginResolutionError;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginLocalDependenciesDenylist;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedDeploymentProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlePluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final Logger logger = LoggerFactory.getLogger(BundlePluginDependenciesResolver.class);
    protected static final String MULE_HTTP_CONNECTOR_ARTIFACT_ID = "mule-http-connector";
    protected static final String MULE_HTTP_CONNECTOR_GROUP_ID = "org.mule.connectors";
    private final ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory;

    public BundlePluginDependenciesResolver(ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory) {
        this.artifactDescriptorFactory = artifactDescriptorFactory;
    }

    @Override
    public List<ArtifactPluginDescriptor> resolve(Set<ArtifactPluginDescriptor> providedPluginDescriptors, List<ArtifactPluginDescriptor> descriptors, boolean isDomain) throws PluginResolutionError {
        List<ArtifactPluginDescriptor> resolvedPlugins = this.resolvePluginsDependencies(descriptors);
        List<ArtifactPluginDescriptor> filteredPluginDescriptors = this.getArtifactPluginDescriptors(providedPluginDescriptors, resolvedPlugins, isDomain);
        this.verifyPluginExportedPackages(filteredPluginDescriptors);
        return filteredPluginDescriptors;
    }

    private List<ArtifactPluginDescriptor> getArtifactPluginDescriptors(Set<ArtifactPluginDescriptor> domainPlugins, List<ArtifactPluginDescriptor> resolvedPlugins, boolean isDomain) {
        ArrayList<ArtifactPluginDescriptor> filteredPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor appPluginDescriptor : resolvedPlugins) {
            Optional<ArtifactPluginDescriptor> pluginDescriptor = this.findPlugin(domainPlugins, appPluginDescriptor.getBundleDescriptor());
            if (!pluginDescriptor.isPresent()) {
                filteredPluginDescriptors.add(appPluginDescriptor);
                continue;
            }
            BundleDescriptor foundPluginBundleDescriptor = pluginDescriptor.get().getBundleDescriptor();
            if (!isDomain && (!foundPluginBundleDescriptor.getArtifactId().equals(MULE_HTTP_CONNECTOR_ARTIFACT_ID) || !foundPluginBundleDescriptor.getGroupId().equals(MULE_HTTP_CONNECTOR_GROUP_ID)) || BundleDescriptorUtils.isCompatibleVersion(foundPluginBundleDescriptor.getVersion(), appPluginDescriptor.getBundleDescriptor().getVersion())) continue;
            throw new IllegalStateException(String.format("Incompatible version of plugin '%s' (%s:%s) found. Artifact requires version '%s' but context provides version '%s'", appPluginDescriptor.getName(), appPluginDescriptor.getBundleDescriptor().getGroupId(), appPluginDescriptor.getBundleDescriptor().getArtifactId(), appPluginDescriptor.getBundleDescriptor().getVersion(), foundPluginBundleDescriptor.getVersion()));
        }
        return filteredPluginDescriptors;
    }

    private Optional<ArtifactPluginDescriptor> findPlugin(Collection<ArtifactPluginDescriptor> appPlugins, BundleDescriptor bundleDescriptor) {
        for (ArtifactPluginDescriptor appPlugin : appPlugins) {
            if (!appPlugin.getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) || !appPlugin.getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())) continue;
            return Optional.of(appPlugin);
        }
        return Optional.empty();
    }

    private List<ArtifactPluginDescriptor> resolvePluginsDependencies(List<ArtifactPluginDescriptor> descriptors) {
        Set<BundleDescriptor> knownPlugins = descriptors.stream().map(ArtifactDescriptor::getBundleDescriptor).collect(Collectors.toSet());
        descriptors = this.getArtifactsWithDependencies(descriptors, knownPlugins);
        ArrayList<ArtifactPluginDescriptor> sortedDescriptors = new ArrayList<ArtifactPluginDescriptor>(descriptors);
        sortedDescriptors.sort((d1, d2) -> d1.getName().compareTo(d2.getName()));
        LinkedList<ArtifactPluginDescriptor> resolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
        LinkedList<ArtifactPluginDescriptor> unresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>(sortedDescriptors);
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedPlugins.size();
            LinkedList<ArtifactPluginDescriptor> pendingUnresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
            for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
                if (this.isResolvedPlugin(unresolvedPlugin, resolvedPlugins)) {
                    this.sanitizeExportedPackages(unresolvedPlugin, resolvedPlugins);
                    resolvedPlugins.add(unresolvedPlugin);
                    continue;
                }
                pendingUnresolvedPlugins.add(unresolvedPlugin);
            }
            unresolvedPlugins = pendingUnresolvedPlugins;
            continueResolution = resolvedPlugins.size() > initialResolvedCount;
        }
        if (unresolvedPlugins.size() != 0) {
            throw new PluginResolutionError(BundlePluginDependenciesResolver.createResolutionErrorMessage(unresolvedPlugins, resolvedPlugins));
        }
        return resolvedPlugins;
    }

    private void verifyPluginExportedPackages(List<ArtifactPluginDescriptor> plugins) {
        HashMap<String, List<String>> exportedPackages = new HashMap<String, List<String>>();
        boolean error = false;
        for (ArtifactPluginDescriptor plugin : plugins) {
            for (String packageName : plugin.getClassLoaderConfiguration().getExportedPackages()) {
                LinkedList<String> exportedOn = (LinkedList<String>)exportedPackages.get(packageName);
                if (exportedOn == null) {
                    exportedOn = new LinkedList<String>();
                    exportedPackages.put(packageName, exportedOn);
                } else {
                    error = true;
                }
                exportedOn.add(plugin.getName());
            }
        }
        if (error) {
            throw new DuplicateExportedPackageException(exportedPackages);
        }
    }

    private List<ArtifactPluginDescriptor> getArtifactsWithDependencies(List<ArtifactPluginDescriptor> pluginDescriptors, Set<BundleDescriptor> visited) {
        ArrayList<ArtifactPluginDescriptor> pluginDescriptorsWithDependences = new ArrayList<ArtifactPluginDescriptor>();
        pluginDescriptorsWithDependences.addAll(pluginDescriptors);
        if (!pluginDescriptors.isEmpty()) {
            ArrayList<ArtifactPluginDescriptor> foundDependencies = new ArrayList<ArtifactPluginDescriptor>();
            pluginDescriptors.stream().filter(pluginDescriptor -> !pluginDescriptor.getClassLoaderConfiguration().getDependencies().isEmpty()).filter(pluginDescriptor -> pluginDescriptor.getBundleDescriptor().isPlugin()).forEach(pluginDescriptor -> pluginDescriptor.getClassLoaderConfiguration().getDependencies().forEach(dependency -> {
                BundleDescriptor availablePluginBundleDescriptor;
                Optional<ArtifactPluginDescriptor> resolvedPluginApplicationLevelOptional = this.findPlugin(pluginDescriptorsWithDependences, dependency.getDescriptor());
                if (this.isPlugin((BundleDependency)dependency) && !this.isResolvedDependency(visited, dependency.getDescriptor())) {
                    if (dependency.getBundleUri() == null) {
                        throw new PluginResolutionError(String.format("Bundle URL should have been resolved for %s.", dependency.getDescriptor()));
                    }
                    File mulePluginLocation = new File(dependency.getBundleUri());
                    if (resolvedPluginApplicationLevelOptional.isPresent()) {
                        ArtifactPluginDescriptor artifactPluginDescriptorResolved = resolvedPluginApplicationLevelOptional.get();
                        logger.warn(String.format("Transitive plugin dependency '[%s -> %s]' is greater than the one resolved for the application '%s', it will be ignored.", pluginDescriptor.getBundleDescriptor(), dependency.getDescriptor(), artifactPluginDescriptorResolved.getBundleDescriptor()));
                        ClassLoaderConfiguration originalClassLoaderConfiguration = pluginDescriptor.getClassLoaderConfiguration();
                        boolean includeLocals = !PluginLocalDependenciesDenylist.isDenylisted(pluginDescriptor.getBundleDescriptor());
                        pluginDescriptor.setClassLoaderConfiguration(this.createBuilderWithoutDependency(originalClassLoaderConfiguration, (BundleDependency)dependency, includeLocals).dependingOn(Collections.singleton(new BundleDependency.Builder().setDescriptor(artifactPluginDescriptorResolved.getBundleDescriptor()).setScope(dependency.getScope()).build())).build());
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Resolving mule-plugin '%s' as transitive dependency ['%s' -> '%s]'", dependency.getDescriptor(), pluginDescriptor.getBundleDescriptor(), dependency.getDescriptor()));
                        }
                        ArtifactPluginDescriptor artifactPluginDescriptor = this.artifactDescriptorFactory.create(mulePluginLocation, Optional.of(new PluginExtendedDeploymentProperties(new Properties(), dependency.getDescriptor(), (ArtifactDescriptor)pluginDescriptor)));
                        artifactPluginDescriptor.setBundleDescriptor(dependency.getDescriptor());
                        foundDependencies.add(artifactPluginDescriptor);
                        visited.add(dependency.getDescriptor());
                    }
                } else if (resolvedPluginApplicationLevelOptional.isPresent() && ObjectUtils.notEqual((Object)(availablePluginBundleDescriptor = resolvedPluginApplicationLevelOptional.get().getBundleDescriptor()).getVersion(), (Object)dependency.getDescriptor().getVersion()) && logger.isDebugEnabled()) {
                    logger.debug(String.format("Transitive plugin dependency '[%s -> %s]' is minor than the one resolved for the application '%s', it will be ignored.", pluginDescriptor.getBundleDescriptor(), dependency.getDescriptor(), availablePluginBundleDescriptor));
                }
            }));
            pluginDescriptorsWithDependences.addAll(this.getArtifactsWithDependencies(foundDependencies, visited));
        }
        return pluginDescriptorsWithDependences;
    }

    private boolean isPlugin(BundleDependency dependency) {
        return dependency.getDescriptor().isPlugin();
    }

    private void sanitizeExportedPackages(ArtifactPluginDescriptor pluginDescriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        Set<String> packagesExportedByDependencies = this.findDependencyPackageClosure(pluginDescriptor.getClassLoaderConfiguration().getDependencies(), resolvedPlugins);
        ClassLoaderConfiguration originalClassLoaderConfiguration = pluginDescriptor.getClassLoaderConfiguration();
        HashSet<String> exportedClassPackages = new HashSet<String>(originalClassLoaderConfiguration.getExportedPackages());
        exportedClassPackages.removeAll(packagesExportedByDependencies);
        boolean includeLocals = !PluginLocalDependenciesDenylist.isDenylisted(pluginDescriptor.getBundleDescriptor());
        pluginDescriptor.setClassLoaderConfiguration(this.createBuilderWithoutExportedPackages(originalClassLoaderConfiguration, includeLocals).exportingPackages(exportedClassPackages).build());
    }

    private ClassLoaderConfiguration.ClassLoaderConfigurationBuilder createBuilderWithoutExportedPackages(ClassLoaderConfiguration originalClassLoaderConfiguration, boolean includeLocals) {
        ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().dependingOn(originalClassLoaderConfiguration.getDependencies()).exportingPrivilegedPackages(originalClassLoaderConfiguration.getPrivilegedExportedPackages(), originalClassLoaderConfiguration.getPrivilegedArtifacts()).exportingResources(originalClassLoaderConfiguration.getExportedResources());
        if (includeLocals) {
            classLoaderConfigurationBuilder.withLocalResources(originalClassLoaderConfiguration.getLocalResources()).withLocalPackages(originalClassLoaderConfiguration.getLocalPackages());
        }
        for (URL url : originalClassLoaderConfiguration.getUrls()) {
            classLoaderConfigurationBuilder.containing(url);
        }
        return classLoaderConfigurationBuilder;
    }

    private ClassLoaderConfiguration.ClassLoaderConfigurationBuilder createBuilderWithoutDependency(ClassLoaderConfiguration originalClassLoaderConfiguration, BundleDependency dependencyToBeExcluded, boolean includeLocals) {
        ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().dependingOn(originalClassLoaderConfiguration.getDependencies().stream().filter(dependency -> !dependency.equals(dependencyToBeExcluded)).collect(Collectors.toSet())).exportingPackages(originalClassLoaderConfiguration.getExportedPackages()).exportingPrivilegedPackages(originalClassLoaderConfiguration.getPrivilegedExportedPackages(), originalClassLoaderConfiguration.getPrivilegedArtifacts()).exportingResources(originalClassLoaderConfiguration.getExportedResources());
        if (includeLocals) {
            classLoaderConfigurationBuilder.withLocalResources(originalClassLoaderConfiguration.getLocalResources()).withLocalPackages(originalClassLoaderConfiguration.getLocalPackages());
        }
        for (URL url : originalClassLoaderConfiguration.getUrls()) {
            classLoaderConfigurationBuilder.containing(url);
        }
        return classLoaderConfigurationBuilder;
    }

    private Set<String> findDependencyPackageClosure(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        HashSet<String> exportedPackages = new HashSet<String>();
        for (BundleDependency pluginDependency : pluginDependencies) {
            Optional<String> classifier = pluginDependency.getDescriptor().getClassifier();
            if (!classifier.isPresent() || !ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(classifier.get())) continue;
            ArtifactPluginDescriptor dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(pluginDependency, resolvedPlugins);
            exportedPackages.addAll(dependencyDescriptor.getClassLoaderConfiguration().getExportedPackages());
            exportedPackages.addAll(this.findDependencyPackageClosure(dependencyDescriptor.getClassLoaderConfiguration().getDependencies(), resolvedPlugins));
        }
        return exportedPackages;
    }

    protected static String createResolutionErrorMessage(List<ArtifactPluginDescriptor> unresolvedPlugins, List<ArtifactPluginDescriptor> resolvedPlugins) {
        StringBuilder builder = new StringBuilder("Unable to resolve plugin dependencies:");
        for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
            builder.append("\nPlugin: ").append(unresolvedPlugin.getName()).append(" missing dependencies:");
            ArrayList<BundleDependency> missingDependencies = new ArrayList<BundleDependency>();
            for (BundleDependency dependency : unresolvedPlugin.getClassLoaderConfiguration().getDependencies()) {
                ArtifactPluginDescriptor dependencyDescriptor;
                Optional<String> classifierOptional = dependency.getDescriptor().getClassifier();
                if (!classifierOptional.isPresent() || !ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(classifierOptional.get()) || (dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins)) != null) continue;
                missingDependencies.add(dependency);
            }
            builder.append(missingDependencies);
        }
        return builder.toString();
    }

    private boolean isResolvedDependency(Set<BundleDescriptor> visited, BundleDescriptor descriptor) {
        for (BundleDescriptor resolvedDependency : visited) {
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedDependency, descriptor)) continue;
            return true;
        }
        return false;
    }

    private boolean isResolvedPlugin(ArtifactPluginDescriptor descriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean isResolved = descriptor.getClassLoaderConfiguration().getDependencies().isEmpty();
        if (!isResolved && this.hasPluginDependenciesResolved(descriptor.getClassLoaderConfiguration().getDependencies(), resolvedPlugins)) {
            isResolved = true;
        }
        return isResolved;
    }

    private static ArtifactPluginDescriptor findArtifactPluginDescriptor(BundleDependency bundleDependency, List<ArtifactPluginDescriptor> resolvedPlugins) {
        ArtifactPluginDescriptor result = null;
        for (ArtifactPluginDescriptor resolvedPlugin : resolvedPlugins) {
            BundleDescriptor resolvedBundleDescriptor = resolvedPlugin.getBundleDescriptor();
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedBundleDescriptor, bundleDependency.getDescriptor())) continue;
            result = resolvedPlugin;
            break;
        }
        return result;
    }

    private static boolean isResolvedDependency(BundleDescriptor availableBundleDescriptor, BundleDescriptor expectedBundleDescriptor) {
        return availableBundleDescriptor.getArtifactId().equals(expectedBundleDescriptor.getArtifactId()) && availableBundleDescriptor.getGroupId().equals(expectedBundleDescriptor.getGroupId()) && BundleDescriptorUtils.isCompatibleVersion(availableBundleDescriptor.getVersion(), expectedBundleDescriptor.getVersion());
    }

    private boolean hasPluginDependenciesResolved(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean resolvedDependency = true;
        for (BundleDependency dependency : pluginDependencies) {
            if (!dependency.getDescriptor().isPlugin() || BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins) != null) continue;
            resolvedDependency = false;
            break;
        }
        return resolvedDependency;
    }
}

