/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.extension.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.api.annotation.NoImplement;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

@NoImplement
public interface ExtensionDiscoveryRequest {
    public static ExtensionDiscoveryRequestBuilder builder() {
        return new ExtensionDiscoveryRequestBuilder();
    }

    public <T> Optional<T> getParameter(String var1);

    public Map<String, Object> getParameters();

    public Collection<ArtifactPluginDescriptor> getArtifactPluginDescriptors();

    public Set<ExtensionModel> getParentArtifactExtensions();

    public boolean isParallelDiscovery();

    public boolean isEnrichDescriptions();

    public boolean isOCSEnabled();

    public boolean isForceExtensionValidation();

    public boolean isResolveMinMuleVersion();

    @NoInstantiate
    public static final class ExtensionDiscoveryRequestBuilder {
        private Collection<ArtifactPluginDescriptor> artifactPlugins;
        private Set<ExtensionModel> parentArtifactExtensions = Collections.emptySet();
        private boolean parallelDiscovery = false;
        private boolean enrichDescriptions = true;
        private boolean ocsEnabled = false;
        private boolean forceExtensionValidation = false;
        private boolean resolveMinMuleVersion = false;
        private final Map<String, Object> customParameters = new HashMap<String, Object>();

        public ExtensionDiscoveryRequestBuilder setArtifactPlugins(Collection<ArtifactPluginDescriptor> artifactPlugins) {
            this.artifactPlugins = artifactPlugins;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParentArtifactExtensions(Set<ExtensionModel> parentArtifactExtensions) {
            this.parentArtifactExtensions = parentArtifactExtensions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setEnrichDescriptions(boolean enrichDescriptions) {
            this.enrichDescriptions = enrichDescriptions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParallelDiscovery(boolean parallelDiscovery) {
            this.parallelDiscovery = parallelDiscovery;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setOCSEnabled(boolean ocsEnabled) {
            this.ocsEnabled = ocsEnabled;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setForceExtensionValidation(boolean forceExtensionValidation) {
            this.forceExtensionValidation = forceExtensionValidation;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setResolveMinMuleVersion(boolean resolveMinMuleVersion) {
            this.resolveMinMuleVersion = resolveMinMuleVersion;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder addParameter(String key, Object value) {
            Preconditions.checkArgument(key != null && key.length() > 0, "key cannot be blank");
            Preconditions.checkArgument(value != null, "value cannot be null");
            this.customParameters.put(key, value);
            return this;
        }

        public ExtensionDiscoveryRequestBuilder addParameters(Map<String, Object> parameters) {
            Preconditions.checkArgument(parameters != null, "cannot add null parameters");
            parameters.forEach(this::addParameter);
            return this;
        }

        public ExtensionDiscoveryRequest build() {
            return new DefaultExtensionDiscoveryRequest(this.artifactPlugins, this.parentArtifactExtensions, this.parallelDiscovery, this.enrichDescriptions, this.ocsEnabled, this.forceExtensionValidation, this.resolveMinMuleVersion, this.customParameters);
        }
    }
}

