/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.function;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.function.FunctionExecutor;
import org.mule.runtime.extension.api.runtime.function.FunctionExecutorFactory;
import org.mule.runtime.extension.api.runtime.function.FunctionParameterDefaultValueResolverFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.function.ReflectiveExpressionFunctionExecutor;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ReflectiveFunctionExecutorFactory<T>
implements FunctionExecutorFactory {
    private final Class<T> implementationClass;
    private final Method method;

    public ReflectiveFunctionExecutorFactory(Class<T> implementationClass, Method method) {
        Preconditions.checkArgument(implementationClass != null, "implementationClass cannot be null");
        Preconditions.checkArgument(method != null, "operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.method = method;
    }

    @Override
    public FunctionExecutor createExecutor(FunctionModel functionModel, FunctionParameterDefaultValueResolverFactory defaultResolverFactory) {
        DataType returnType = DataType.fromType(ExtensionMetadataTypeUtils.getType(functionModel.getOutput().getType()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to obtain the return type for function [%s]", functionModel.getName())))));
        List<FunctionParameter> functionParameters = functionModel.getAllParameterModels().stream().map(p -> {
            DataType type;
            MetadataType paramType = p.getType();
            DataType dataType = type = ExtensionMetadataTypeUtils.isTypedValue(paramType) ? DataType.fromType(TypedValue.class) : IntrospectionUtils.toDataType(paramType);
            if (p.isRequired()) {
                return new FunctionParameter(p.getName(), type);
            }
            Object defaultValue = p.getDefaultValue();
            if (defaultValue == null) {
                return new FunctionParameter(p.getName(), type, context -> ReflectiveFunctionExecutorFactory.getDefaultValue(type.getType()));
            }
            return new FunctionParameter(p.getName(), type, defaultResolverFactory.create(defaultValue, type));
        }).collect(Collectors.toList());
        return new ReflectiveExpressionFunctionExecutor(functionModel, returnType, functionParameters, this.method, this.getDelegateInstance());
    }

    private static Object getDefaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return false;
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            if (type == Integer.TYPE) {
                return 0;
            }
            if (type == Long.TYPE) {
                return 0L;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return 0.0;
            }
        }
        return null;
    }

    private Object getDelegateInstance() {
        T delegate;
        try {
            delegate = this.implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of operation class " + this.implementationClass.getName()), (Throwable)e);
        }
        return delegate;
    }
}

