/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import java.util.function.Supplier;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;

public class TopLevelParameterObjectFactory
extends AbstractExtensionObjectFactory<Object>
implements ObjectTypeProvider {
    private LazyValue<DefaultObjectBuilder> builder;
    private LazyValue<Class<?>> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private String name;
    private Object staticProduct = null;

    public TopLevelParameterObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        this.objectClass = new LazyValue<Supplier<Class>>(() -> ClassUtils.withContextClassLoader(classLoader, () -> AnnotatedObjectInvocationHandler.addAnnotationsToClass(JavaTypeUtils.getType(type))));
        this.builder = new LazyValue<Supplier<DefaultObjectBuilder>>(() -> new DefaultObjectBuilder(this.objectClass.get(), this.reflectionCache));
    }

    @Override
    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader(this.classLoader, () -> {
            DefaultObjectBuilder builder = this.builder.get();
            this.resolveParameters(this.objectType, builder);
            this.resolveParameterGroups(this.objectType, builder);
            this.injectFields();
            ObjectBuilderValueResolver resolver = new ObjectBuilderValueResolver(builder, this.muleContext.getInjector());
            if (resolver.isDynamic()) {
                return resolver;
            }
            CoreEvent initialiserEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
            try {
                ValueResolvingContext ctx = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).build();
                try {
                    this.staticProduct = resolver.resolve(ctx);
                    this.muleContext.getInjector().inject(this.staticProduct);
                    Object object = this.staticProduct;
                    if (ctx != null) {
                        ctx.close();
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    private void injectFields() {
        DefaultObjectBuilder builder = this.builder.get();
        builder.setEncoding(this.artifactEncoding.getDefaultEncoding().name());
        if (this.name != null) {
            builder.setName(this.name);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class<?> getObjectType() {
        return this.objectClass.get();
    }
}

