/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.loader.parser.ActingParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaActingParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaValueProviderFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterUtils;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.values.OfValues;
import org.mule.sdk.api.annotation.values.ValuePart;

class JavaValueProviderModelParser
implements ValueProviderModelParser {
    private static final SinceMuleVersionModelProperty SINCE_MULE_VERSION_MODEL_PROPERTY_SDK_API_VP = new SinceMuleVersionModelProperty("4.4.0");
    private final Class<?> clazz;
    private final boolean isOpen;
    private final Optional<Integer> partOrder;
    private final boolean fromLegacyAnnotation;
    private final List<FieldElement> providerParameters;
    private final List<ActingParameterModelParser> actingParameterModelParsers;
    private final List<FieldElement> configFields;
    private final List<FieldElement> connectionFields;

    public static Optional<JavaValueProviderModelParser> parseFromOfValues(ExtensionParameter ofValuesSource, ExtensionParameter valuePartsSource, String elementType, ClassTypeLoader typeLoader) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(ofValuesSource, elementType, ofValuesSource.getName(), org.mule.runtime.extension.api.annotation.values.OfValues.class, OfValues.class, fetcher -> JavaValueProviderModelParser.getFromOfValuesFetcherLegacy(valuePartsSource, fetcher, typeLoader), fetcher -> JavaValueProviderModelParser.getFromOfValuesFetcher(valuePartsSource, fetcher, typeLoader)).filter(ofValueInformation -> ofValueInformation.clazz != null);
    }

    private static JavaValueProviderModelParser getFromOfValuesFetcherLegacy(ExtensionParameter valuePartsSource, AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.values.OfValues> fetcher, ClassTypeLoader typeLoader) {
        return new JavaValueProviderModelParser(fetcher.getClassValue(org.mule.runtime.extension.api.annotation.values.OfValues::value).getDeclaringClass().orElse(null), fetcher.getBooleanValue(org.mule.runtime.extension.api.annotation.values.OfValues::open), Collections.emptyMap(), JavaValueProviderModelParser.getPartOrderFromValueParts(valuePartsSource), typeLoader, true);
    }

    private static JavaValueProviderModelParser getFromOfValuesFetcher(ExtensionParameter valuePartsSource, AnnotationValueFetcher<OfValues> fetcher, ClassTypeLoader typeLoader) {
        return new JavaValueProviderModelParser(fetcher.getClassValue(OfValues::value).getDeclaringClass().orElse(null), fetcher.getBooleanValue(OfValues::open), JavaValueProviderModelParser.getBindingsMapFromFetcher(fetcher.getInnerAnnotations(OfValues::bindings)), JavaValueProviderModelParser.getPartOrderFromValueParts(valuePartsSource), typeLoader, false);
    }

    private static Optional<Integer> getPartOrderFromValueParts(ExtensionParameter valuePartsSource) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(valuePartsSource, "parameter", valuePartsSource.getName(), org.mule.runtime.extension.api.annotation.values.ValuePart.class, ValuePart.class, fetcher -> fetcher.getNumberValue(org.mule.runtime.extension.api.annotation.values.ValuePart::order), fetcher -> fetcher.getNumberValue(ValuePart::order));
    }

    private static Map<String, String> getBindingsMapFromFetcher(List<AnnotationValueFetcher<Binding>> annotationValueFetcher) {
        return annotationValueFetcher.stream().collect(Collectors.toMap(fetcher -> fetcher.getStringValue(Binding::actingParameter), fetcher -> fetcher.getStringValue(Binding::extractionExpression)));
    }

    protected JavaValueProviderModelParser(Class<?> clazz, boolean isOpen, Map<String, String> bindingsMap, Optional<Integer> partOrder, ClassTypeLoader typeLoader, boolean fromLegacyAnnotation) {
        this.clazz = clazz;
        this.isOpen = isOpen;
        this.partOrder = partOrder;
        this.fromLegacyAnnotation = fromLegacyAnnotation;
        ParameterizableTypeWrapper providerClassWrapper = new ParameterizableTypeWrapper((Class)clazz, typeLoader);
        this.providerParameters = ParameterUtils.getParameterFields(providerClassWrapper);
        this.configFields = ParameterUtils.getConfigFields(providerClassWrapper);
        this.connectionFields = ParameterUtils.getConnectionFields(providerClassWrapper);
        this.actingParameterModelParsers = this.providerParameters.stream().map(fieldElement -> this.getActingParameterModelParser((FieldElement)fieldElement, bindingsMap)).toList();
    }

    @Override
    public String getId() {
        return ValueProviderUtils.getValueProviderId(this.clazz);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public List<ActingParameterModelParser> getActingParameterParsers() {
        return this.actingParameterModelParsers;
    }

    @Override
    public boolean requiresConfiguration() {
        return !this.configFields.isEmpty();
    }

    @Override
    public boolean requiresConnection() {
        return !this.connectionFields.isEmpty();
    }

    @Override
    public Optional<Integer> getPartOrder() {
        return this.partOrder;
    }

    @Override
    public ValueProviderFactory getValueProviderFactory() {
        return new JavaValueProviderFactory(this.clazz, this.providerParameters, this.configFields.isEmpty() ? null : this.configFields.get(0), this.connectionFields.isEmpty() ? null : this.connectionFields.get(0));
    }

    private ActingParameterModelParser getActingParameterModelParser(FieldElement fieldElement, Map<String, String> bindingsMap) {
        return new JavaActingParameterModelParser(fieldElement.getName(), fieldElement.isRequired(), bindingsMap.get(fieldElement.getName()));
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return this.fromLegacyAnnotation ? Collections.emptyList() : Collections.singletonList(SINCE_MULE_VERSION_MODEL_PROPERTY_SDK_API_VP);
    }
}

