/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;

abstract class AbstractPlatformOAuthStateAdapter
implements OAuthState {
    private String accessToken;
    private Optional<String> expiresIn;

    public AbstractPlatformOAuthStateAdapter(PlatformManagedOAuthDancer dancer, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.updateState(dancer.getContext());
        dancer.addListener(new PlatformManagedOAuthStateListener(){

            @Override
            public void onAccessToken(ResourceOwnerOAuthContext context) {
                this.doUpdate(context);
            }

            @Override
            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                this.doUpdate(context);
            }

            private void doUpdate(ResourceOwnerOAuthContext context) {
                AbstractPlatformOAuthStateAdapter.this.updateState(context);
                onUpdate.accept(context);
            }
        });
    }

    private void updateState(ResourceOwnerOAuthContext context) {
        this.accessToken = context.getAccessToken();
        this.expiresIn = Optional.ofNullable(context.getExpiresIn());
    }

    @Override
    public final String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public final Optional<String> getExpiresIn() {
        return this.expiresIn;
    }
}

