/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class MapValueResolver<K, V>
implements ValueResolver<Map<K, V>>,
Initialisable {
    private final Supplier<? extends Map> mapFactory;
    private final List<ValueResolver<V>> valueResolvers;
    private final List<ValueResolver<K>> keyResolvers;
    private final Injector injector;

    private MapValueResolver(Supplier<? extends Map> mapFactory, List<ValueResolver<K>> keyResolvers, List<ValueResolver<V>> valueResolvers, Injector injector) {
        Objects.requireNonNull(mapFactory);
        Objects.requireNonNull(keyResolvers, "resolvers cannot be null");
        Objects.requireNonNull(valueResolvers, "resolvers cannot be null");
        Preconditions.checkArgument(keyResolvers.size() == valueResolvers.size(), "exactly one valueResolver for each keyResolver is required");
        this.mapFactory = mapFactory;
        this.keyResolvers = keyResolvers;
        this.valueResolvers = valueResolvers;
        this.injector = injector;
    }

    public static <K, V> MapValueResolver<K, V> of(Class<? extends Map> mapType, List<ValueResolver<K>> keyResolvers, List<ValueResolver<V>> valueResolvers, Injector injector) {
        if (ConcurrentMap.class.equals(mapType)) {
            return new MapValueResolver<K, V>(ConcurrentHashMap::new, keyResolvers, valueResolvers, injector);
        }
        if (Map.class.equals(mapType)) {
            return new MapValueResolver<K, V>(HashMap::new, keyResolvers, valueResolvers, injector);
        }
        return new MapValueResolver<K, V>(() -> {
            try {
                return (Map)mapType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of {}", mapType.getName()), (Throwable)e);
            }
        }, keyResolvers, valueResolvers, injector);
    }

    @Override
    public Map<K, V> resolve(ValueResolvingContext context) throws MuleException {
        Map<K, V> map = this.instantiateMap();
        Iterator<ValueResolver<K>> keyIt = this.keyResolvers.iterator();
        Iterator<ValueResolver<V>> valueIt = this.valueResolvers.iterator();
        while (keyIt.hasNext() && valueIt.hasNext()) {
            try {
                map.put(keyIt.next().resolve(context), valueIt.next().resolve(context));
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
        return map;
    }

    @Override
    public boolean isDynamic() {
        try {
            return MuleExtensionUtils.hasAnyDynamic(this.keyResolvers) || MuleExtensionUtils.hasAnyDynamic(this.valueResolvers);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Map<K, V> instantiateMap() {
        return this.mapFactory.get();
    }

    @Override
    public void initialise() throws InitialisationException {
        for (ValueResolver<V> valueResolver : this.valueResolvers) {
            LifecycleUtils.initialiseIfNeeded(valueResolver, this.injector);
        }
    }

    public List<ValueResolver<K>> getKeyResolvers() {
        return this.keyResolvers;
    }

    public List<ValueResolver<V>> getValueResolvers() {
        return this.valueResolvers;
    }
}

