/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.properties.api.ResourceProvider;

public class ClassLoaderResourceProvider
implements ResourceProvider {
    private ClassLoader classLoader;

    public ClassLoaderResourceProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        URL resource = this.resourceAsUrl(resourceName);
        try {
            return IOUtils.getInputStreamWithCacheControl(resource);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Path getResourceAsPath(String resourceName) {
        URL resource = this.classLoader.getResource(resourceName);
        try {
            return new File(resource.toURI()).getAbsoluteFile().toPath();
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private URL resourceAsUrl(String resourceName) {
        URL resource = this.classLoader.getResource(resourceName);
        if (resource == null) {
            File resourceFile = new File(resourceName);
            if (resourceFile.exists()) {
                try {
                    resource = resourceFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new MuleRuntimeException(e);
                }
            } else {
                throw new ResourceNotFoundException(I18nMessageFactory.createStaticMessage("Couldn't find resource: %s neither on classpath or in file system", resourceName));
            }
        }
        return resource;
    }
}

