/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.meter;

import java.util.Map;
import java.util.function.BiConsumer;
import org.mule.runtime.metrics.api.instrument.builder.LongCounterBuilder;
import org.mule.runtime.metrics.api.instrument.builder.LongUpDownCounterBuilder;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.instrument.DefaultLongCounter;
import org.mule.runtime.metrics.impl.instrument.DefaultLongUpDownCounter;
import org.mule.runtime.metrics.impl.instrument.repository.InstrumentRepository;
import org.mule.runtime.metrics.impl.meter.BaseMeterBuilder;
import org.mule.runtime.metrics.impl.meter.builder.MeterBuilderWithRepository;

public class DefaultMeter
implements Meter {
    private final MeterExporter meterExporter;
    private final Map<String, String> meterAttributes;
    private final String meterName;
    private final String description;
    private final InstrumentRepository instrumentRepository = new InstrumentRepository();

    public static MeterBuilderWithRepository builder(String meterName) {
        return new BaseMeterBuilder(meterName){

            @Override
            protected DefaultMeter doBuild(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
                return new DefaultMeter(meterName, description, meterExporter, meterAttributes);
            }
        };
    }

    private DefaultMeter(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
        this.meterName = meterName;
        this.description = description;
        this.meterExporter = meterExporter;
        this.meterAttributes = meterAttributes;
        meterExporter.registerMeterToExport(this);
    }

    @Override
    public String getName() {
        return this.meterName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.meterAttributes.forEach(biConsumer);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String counterName) {
        return DefaultLongUpDownCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    @Override
    public LongCounterBuilder counterBuilder(String counterName) {
        return DefaultLongCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }
}

